/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.UpdateAvailableBadge;
import com.terraformersmc.modmenu.gui.widget.entries.ModListEntry;
import com.terraformersmc.modmenu.util.VersionUtil;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_757;
import net.minecraft.class_8219;

public class DescriptionListWidget
extends class_350<DescriptionEntry> {
    private static final class_2561 HAS_UPDATE_TEXT = class_2561.method_43471((String)"modmenu.hasUpdate");
    private static final class_2561 EXPERIMENTAL_TEXT = class_2561.method_43471((String)"modmenu.experimental").method_27692(class_124.field_1065);
    private static final class_2561 MODRINTH_TEXT = class_2561.method_43471((String)"modmenu.modrinth");
    private static final class_2561 CHILD_HAS_UPDATE_TEXT = class_2561.method_43471((String)"modmenu.childHasUpdate");
    private static final class_2561 LINKS_TEXT = class_2561.method_43471((String)"modmenu.links");
    private static final class_2561 SOURCE_TEXT = class_2561.method_43471((String)"modmenu.source").method_27692(class_124.field_1078).method_27692(class_124.field_1073);
    private static final class_2561 LICENSE_TEXT = class_2561.method_43471((String)"modmenu.license");
    private static final class_2561 VIEW_CREDITS_TEXT = class_2561.method_43471((String)"modmenu.viewCredits").method_27692(class_124.field_1078).method_27692(class_124.field_1073);
    private static final class_2561 CREDITS_TEXT = class_2561.method_43471((String)"modmenu.credits");
    private final ModsScreen parent;
    private final class_327 textRenderer;
    private ModListEntry lastSelected = null;

    public DescriptionListWidget(class_310 client, int width, int height, int top, int bottom, int entryHeight, ModsScreen parent) {
        super(client, width, height, top, bottom, entryHeight);
        this.parent = parent;
        this.textRenderer = client.field_1772;
    }

    public DescriptionEntry getSelectedOrNull() {
        return null;
    }

    public int method_25322() {
        return this.field_22742 - 10;
    }

    protected int method_25329() {
        return this.field_22742 - 6 + this.field_19088;
    }

    public void method_37020(class_6382 builder) {
        Mod mod = this.parent.getSelectedEntry().getMod();
        builder.method_37033(class_6381.field_33788, mod.getTranslatedName() + " " + mod.getPrefixedVersion());
    }

    public void method_25394(class_332 DrawContext, int mouseX, int mouseY, float delta) {
        ModListEntry selectedEntry = this.parent.getSelectedEntry();
        if (selectedEntry != this.lastSelected) {
            this.lastSelected = selectedEntry;
            this.method_25339();
            this.method_25307(-1.7976931348623157E308);
            if (this.lastSelected != null) {
                DescriptionEntry emptyEntry = new DescriptionEntry(class_5481.field_26385);
                int wrapWidth = this.method_25322() - 5;
                Mod mod = this.lastSelected.getMod();
                String description = mod.getTranslatedDescription();
                if (!description.isEmpty()) {
                    for (Object line : this.textRenderer.method_1728((class_5348)class_2561.method_43470((String)description.replaceAll("\n", "\n\n")), wrapWidth)) {
                        this.method_25396().add(new DescriptionEntry((class_5481)line));
                    }
                }
                if (ModMenuConfig.UPDATE_CHECKER.getValue() && !ModMenuConfig.DISABLE_UPDATE_CHECKER.getValue().contains(mod.getId())) {
                    Object entry;
                    if (mod.getModrinthData() != null) {
                        this.method_25396().add(emptyEntry);
                        int index = 0;
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)HAS_UPDATE_TEXT, wrapWidth - 11)) {
                            entry = new DescriptionEntry(line);
                            if (index == 0) {
                                ((DescriptionEntry)((Object)entry)).setUpdateTextEntry();
                            }
                            this.method_25396().add(entry);
                            ++index;
                        }
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)EXPERIMENTAL_TEXT, wrapWidth - 16)) {
                            this.method_25396().add(new DescriptionEntry(line, 8));
                        }
                        class_5250 updateText = class_2561.method_43469((String)"modmenu.updateText", (Object[])new Object[]{VersionUtil.stripPrefix(mod.getModrinthData().versionNumber()), MODRINTH_TEXT}).method_27692(class_124.field_1078).method_27692(class_124.field_1073);
                        String versionLink = "https://modrinth.com/project/%s/version/%s".formatted(mod.getModrinthData().projectId(), mod.getModrinthData().versionId());
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)updateText, wrapWidth - 16)) {
                            this.method_25396().add(new LinkEntry(line, versionLink, 8));
                        }
                    }
                    if (mod.getChildHasUpdate()) {
                        this.method_25396().add(emptyEntry);
                        int index = 0;
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)CHILD_HAS_UPDATE_TEXT, wrapWidth - 11)) {
                            entry = new DescriptionEntry(line);
                            if (index == 0) {
                                ((DescriptionEntry)((Object)entry)).setUpdateTextEntry();
                            }
                            this.method_25396().add(entry);
                            ++index;
                        }
                    }
                }
                Map<String, String> links = mod.getLinks();
                String sourceLink = mod.getSource();
                if (!(links.isEmpty() && sourceLink == null || ModMenuConfig.HIDE_MOD_LINKS.getValue())) {
                    this.method_25396().add(emptyEntry);
                    for (Object line : this.textRenderer.method_1728((class_5348)LINKS_TEXT, wrapWidth)) {
                        this.method_25396().add(new DescriptionEntry((class_5481)line));
                    }
                    if (sourceLink != null) {
                        int indent = 8;
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)SOURCE_TEXT, wrapWidth - 16)) {
                            this.method_25396().add(new LinkEntry(line, sourceLink, indent));
                            indent = 16;
                        }
                    }
                    links.forEach((key, value) -> {
                        int indent = 8;
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)class_2561.method_43471((String)key).method_27692(class_124.field_1078).method_27692(class_124.field_1073), wrapWidth - 16)) {
                            this.method_25396().add(new LinkEntry(line, (String)value, indent));
                            indent = 16;
                        }
                    });
                }
                Set<String> licenses = mod.getLicense();
                if (!ModMenuConfig.HIDE_MOD_LICENSE.getValue() && !licenses.isEmpty()) {
                    this.method_25396().add(emptyEntry);
                    for (class_5481 line : this.textRenderer.method_1728((class_5348)LICENSE_TEXT, wrapWidth)) {
                        this.method_25396().add(new DescriptionEntry(line));
                    }
                    for (String license : licenses) {
                        int indent = 8;
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)class_2561.method_43470((String)license), wrapWidth - 16)) {
                            this.method_25396().add(new DescriptionEntry(line, indent));
                            indent = 16;
                        }
                    }
                }
                if (!ModMenuConfig.HIDE_MOD_CREDITS.getValue()) {
                    List<String> credits;
                    if ("minecraft".equals(mod.getId())) {
                        this.method_25396().add(emptyEntry);
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)VIEW_CREDITS_TEXT, wrapWidth)) {
                            this.method_25396().add(new MojangCreditsEntry(line));
                        }
                    } else if (!"java".equals(mod.getId()) && !(credits = mod.getCredits()).isEmpty()) {
                        this.method_25396().add(emptyEntry);
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)CREDITS_TEXT, wrapWidth)) {
                            this.method_25396().add(new DescriptionEntry(line));
                        }
                        for (String credit : credits) {
                            int indent = 8;
                            for (class_5481 line : this.textRenderer.method_1728((class_5348)class_2561.method_43470((String)credit), wrapWidth - 16)) {
                                this.method_25396().add(new DescriptionEntry(line, indent));
                                indent = 16;
                            }
                        }
                    }
                }
            }
        }
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)class_437.field_44669);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferBuilder.method_22912((double)this.field_19088, (double)this.field_19086, 0.0).method_22913((float)this.field_19088 / 32.0f, (float)(this.field_19086 + (int)this.method_25341()) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_19087, (double)this.field_19086, 0.0).method_22913((float)this.field_19087 / 32.0f, (float)(this.field_19086 + (int)this.method_25341()) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_19087, (double)this.field_19085, 0.0).method_22913((float)this.field_19087 / 32.0f, (float)(this.field_19085 + (int)this.method_25341()) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_19088, (double)this.field_19085, 0.0).method_22913((float)this.field_19088 / 32.0f, (float)(this.field_19085 + (int)this.method_25341()) / 32.0f).method_1336(32, 32, 32, 255).method_1344();
        tessellator.method_1350();
        this.method_49603(DrawContext);
        this.method_25311(DrawContext, mouseX, mouseY, delta);
        DrawContext.method_44380();
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ZERO, (GlStateManager.class_4534)GlStateManager.class_4534.ONE);
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22912((double)this.field_19088, (double)(this.field_19085 + 4), 0.0).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)this.field_19087, (double)(this.field_19085 + 4), 0.0).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)this.field_19087, (double)this.field_19085, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_19088, (double)this.field_19085, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_19088, (double)this.field_19086, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_19087, (double)this.field_19086, 0.0).method_1336(0, 0, 0, 255).method_1344();
        bufferBuilder.method_22912((double)this.field_19087, (double)(this.field_19086 - 4), 0.0).method_1336(0, 0, 0, 0).method_1344();
        bufferBuilder.method_22912((double)this.field_19088, (double)(this.field_19086 - 4), 0.0).method_1336(0, 0, 0, 0).method_1344();
        tessellator.method_1350();
        this.renderScrollBar(bufferBuilder, tessellator);
        RenderSystem.disableBlend();
    }

    public void renderScrollBar(class_287 bufferBuilder, class_289 tessellator) {
        int scrollbarStartX = this.method_25329();
        int scrollbarEndX = scrollbarStartX + 6;
        int maxScroll = this.method_25331();
        if (maxScroll > 0) {
            int p = (int)((float)((this.field_19086 - this.field_19085) * (this.field_19086 - this.field_19085)) / (float)this.method_25317());
            p = class_3532.method_15340((int)p, (int)32, (int)(this.field_19086 - this.field_19085 - 8));
            int q = (int)this.method_25341() * (this.field_19086 - this.field_19085 - p) / maxScroll + this.field_19085;
            if (q < this.field_19085) {
                q = this.field_19085;
            }
            RenderSystem.setShader(class_757::method_34540);
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            bufferBuilder.method_22912((double)scrollbarStartX, (double)this.field_19086, 0.0).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)scrollbarEndX, (double)this.field_19086, 0.0).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)scrollbarEndX, (double)this.field_19085, 0.0).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)scrollbarStartX, (double)this.field_19085, 0.0).method_1336(0, 0, 0, 255).method_1344();
            bufferBuilder.method_22912((double)scrollbarStartX, (double)(q + p), 0.0).method_1336(128, 128, 128, 255).method_1344();
            bufferBuilder.method_22912((double)scrollbarEndX, (double)(q + p), 0.0).method_1336(128, 128, 128, 255).method_1344();
            bufferBuilder.method_22912((double)scrollbarEndX, (double)q, 0.0).method_1336(128, 128, 128, 255).method_1344();
            bufferBuilder.method_22912((double)scrollbarStartX, (double)q, 0.0).method_1336(128, 128, 128, 255).method_1344();
            bufferBuilder.method_22912((double)scrollbarStartX, (double)(q + p - 1), 0.0).method_1336(192, 192, 192, 255).method_1344();
            bufferBuilder.method_22912((double)(scrollbarEndX - 1), (double)(q + p - 1), 0.0).method_1336(192, 192, 192, 255).method_1344();
            bufferBuilder.method_22912((double)(scrollbarEndX - 1), (double)q, 0.0).method_1336(192, 192, 192, 255).method_1344();
            bufferBuilder.method_22912((double)scrollbarStartX, (double)q, 0.0).method_1336(192, 192, 192, 255).method_1344();
            tessellator.method_1350();
        }
    }

    protected class DescriptionEntry
    extends class_4265.class_4266<DescriptionEntry> {
        protected class_5481 text;
        protected int indent;
        public boolean updateTextEntry = false;

        public DescriptionEntry(class_5481 text, int indent) {
            this.text = text;
            this.indent = indent;
        }

        public DescriptionEntry(class_5481 text) {
            this(text, 0);
        }

        public DescriptionEntry setUpdateTextEntry() {
            this.updateTextEntry = true;
            return this;
        }

        public void method_25343(class_332 DrawContext, int index, int y, int x, int itemWidth, int itemHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (this.updateTextEntry) {
                UpdateAvailableBadge.renderBadge(DrawContext, x + this.indent, y);
                x += 11;
            }
            DrawContext.method_35720(DescriptionListWidget.this.textRenderer, this.text, x + this.indent, y, 0xAAAAAA);
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> method_37025() {
            return Collections.emptyList();
        }
    }

    protected class LinkEntry
    extends DescriptionEntry {
        private final String link;

        public LinkEntry(class_5481 text, String link, int indent) {
            super(text, indent);
            this.link = link;
        }

        public LinkEntry(class_5481 text, String link) {
            this(text, link, 0);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25405(mouseX, mouseY)) {
                DescriptionListWidget.this.field_22740.method_1507((class_437)new class_407(open -> {
                    if (open) {
                        class_156.method_668().method_670(this.link);
                    }
                    DescriptionListWidget.this.field_22740.method_1507((class_437)DescriptionListWidget.this.parent);
                }, this.link, false));
            }
            return super.method_25402(mouseX, mouseY, button);
        }
    }

    protected class MojangCreditsEntry
    extends DescriptionEntry {
        public MojangCreditsEntry(class_5481 text) {
            super(text);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25405(mouseX, mouseY)) {
                DescriptionListWidget.this.field_22740.method_1507((class_437)new MinecraftCredits());
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        class MinecraftCredits
        extends class_8219 {
            public MinecraftCredits() {
                super((class_437)DescriptionListWidget.this.parent);
            }
        }
    }
}

