/*
 * Decompiled with CFR 0.152.
 */
package com.tpwalke2.bluemapsignmarkers.core.bluemap;

import com.tpwalke2.bluemapsignmarkers.core.bluemap.IResetHandler;
import com.tpwalke2.bluemapsignmarkers.core.bluemap.actions.AddMarkerAction;
import com.tpwalke2.bluemapsignmarkers.core.bluemap.actions.MarkerAction;
import com.tpwalke2.bluemapsignmarkers.core.bluemap.actions.RemoveMarkerAction;
import com.tpwalke2.bluemapsignmarkers.core.bluemap.actions.UpdateMarkerAction;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerGroup;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerGroupType;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerSetIdentifier;
import com.tpwalke2.bluemapsignmarkers.core.reactive.ReactiveQueue;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.BlueMapWorld;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueMapAPIConnector {
    public static final String MAP_NOT_FOUND = "Map not found: {}";
    public static final String WORLD_NOT_FOUND = "World not found: {}";
    public static final String WORLD_MAPS_EMPTY = "World maps empty: {}";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"bluemapsignmarkers");
    private ReactiveQueue<MarkerAction> markerActionQueue;
    private Map<MarkerSetIdentifier, MarkerSet> markerSets;
    private BlueMapAPI blueMapAPI;
    private List<IResetHandler> resetHandlers = new ArrayList<IResetHandler>();

    public BlueMapAPIConnector() {
        this.resetQueue();
        BlueMapAPI.onEnable(this::onEnable);
        BlueMapAPI.onDisable(this::onDisable);
    }

    public void shutdown() {
        BlueMapAPI.unregisterListener(this::onEnable);
        BlueMapAPI.unregisterListener(this::onDisable);
    }

    public void dispatch(MarkerAction action) {
        this.markerActionQueue.enqueue(action);
    }

    public void addResetHandler(IResetHandler handler) {
        this.resetHandlers.add(handler);
    }

    private void fireReset() {
        this.resetHandlers.forEach(IResetHandler::reset);
    }

    private void resetQueue() {
        this.markerActionQueue = new ReactiveQueue<MarkerAction>(() -> BlueMapAPI.getInstance().isPresent(), this::processMarkerAction, this::onError);
        this.markerSets = new ConcurrentHashMap<MarkerSetIdentifier, MarkerSet>();
    }

    private void processMarkerAction(MarkerAction markerAction) {
        LOGGER.info("Processing marker action: {}", (Object)markerAction);
        Optional<MarkerSet> markerSet = this.getMarkerSet(markerAction.getMarkerIdentifier().parentSet());
        if (markerSet.isEmpty()) {
            LOGGER.debug("Marker set not found.");
            return;
        }
        LOGGER.debug("Marker set found.");
        Map markerSetMap = markerSet.get().getMarkers();
        if (markerAction instanceof AddMarkerAction) {
            AddMarkerAction addAction = (AddMarkerAction)markerAction;
            LOGGER.debug("Adding marker...");
            MarkerGroup markerGroup = addAction.getMarkerIdentifier().parentSet().markerGroup();
            if (markerGroup.type() == MarkerGroupType.POI) {
                LOGGER.debug("Adding POI marker...");
                POIMarker.Builder markerBuilder = ((POIMarker.Builder)((POIMarker.Builder)POIMarker.builder().position(addAction.getX(), addAction.getY(), addAction.getZ())).label(addAction.getLabel())).detail(addAction.getDetail());
                if (markerGroup.icon() != null && !markerGroup.icon().isEmpty()) {
                    markerBuilder.icon(markerGroup.icon(), markerGroup.offsetX(), markerGroup.offsetY());
                }
                LOGGER.debug("Adding marker (id {}) to marker set: {}", (Object)addAction.getMarkerIdentifier().getId(), (Object)markerSetMap);
                markerSetMap.put(addAction.getMarkerIdentifier().getId(), markerBuilder.build());
            }
        } else if (markerAction instanceof RemoveMarkerAction) {
            RemoveMarkerAction removeAction = (RemoveMarkerAction)markerAction;
            LOGGER.debug("Removing marker...");
            markerSetMap.remove(removeAction.getMarkerIdentifier().getId());
        } else if (markerAction instanceof UpdateMarkerAction) {
            UpdateMarkerAction updateAction = (UpdateMarkerAction)markerAction;
            LOGGER.debug("Updating marker...");
            Marker marker = Optional.of((Marker)markerSetMap.get(markerAction.getMarkerIdentifier().getId())).get();
            marker.setLabel(updateAction.getNewLabel());
            if (marker instanceof POIMarker) {
                POIMarker poiMarker = (POIMarker)marker;
                poiMarker.setDetail(updateAction.getNewDetails());
            }
        } else {
            LOGGER.warn("Unknown marker action: {}", (Object)markerAction);
        }
    }

    private void onError(Throwable throwable) {
        LOGGER.error("Error processing marker action", throwable);
    }

    private void onEnable(BlueMapAPI api) {
        if (this.markerActionQueue.isShutdown()) {
            this.resetQueue();
            this.fireReset();
        }
        this.blueMapAPI = api;
        this.markerActionQueue.process();
    }

    private void onDisable(BlueMapAPI api) {
        this.markerActionQueue.shutdown();
    }

    private synchronized Optional<MarkerSet> getMarkerSet(MarkerSetIdentifier markerSetIdentifier) {
        Optional<MarkerSet> result = Optional.ofNullable(this.markerSets.get(markerSetIdentifier));
        if (result.isPresent()) {
            return result;
        }
        LOGGER.debug("Marker set not found. Attempting to build marker set: {}", (Object)markerSetIdentifier);
        Optional<BlueMapMap> map = this.getMap(markerSetIdentifier.mapId());
        if (map.isEmpty()) {
            LOGGER.warn(MAP_NOT_FOUND, (Object)markerSetIdentifier.mapId());
            return result;
        }
        MarkerSet markerSet = Optional.ofNullable(this.markerSets.get(markerSetIdentifier)).or(() -> Optional.ofNullable((MarkerSet)((BlueMapMap)map.get()).getMarkerSets().get(markerSetIdentifier.markerGroup().prefix()))).orElseGet(() -> MarkerSet.builder().label(markerSetIdentifier.markerGroup().name()).build());
        LOGGER.debug("Caching marker set: {}", (Object)markerSetIdentifier);
        this.markerSets.putIfAbsent(markerSetIdentifier, markerSet);
        map.get().getMarkerSets().putIfAbsent(markerSetIdentifier.markerGroup().prefix(), markerSet);
        return Optional.of(markerSet);
    }

    private Optional<BlueMapMap> getMap(String mapId) {
        Optional result = this.blueMapAPI.getMap(mapId);
        if (result.isPresent()) {
            return result;
        }
        Optional world = this.blueMapAPI.getWorld((Object)mapId);
        if (world.isEmpty()) {
            LOGGER.warn(WORLD_NOT_FOUND, (Object)mapId);
            return Optional.empty();
        }
        Collection maps = ((BlueMapWorld)world.get()).getMaps();
        if (maps.isEmpty()) {
            LOGGER.warn(WORLD_MAPS_EMPTY, (Object)mapId);
            return Optional.empty();
        }
        return maps.stream().findFirst();
    }
}

