/*
 * Decompiled with CFR 0.152.
 */
package com.tpwalke2.bluemapsignmarkers.core.signs;

import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerGroup;
import com.tpwalke2.bluemapsignmarkers.core.signs.ParsingContext;
import com.tpwalke2.bluemapsignmarkers.core.signs.SignLinesParseResult;
import java.util.List;

public class SignLinesParser {
    private final List<MarkerGroup> markerGroups;

    public SignLinesParser(List<MarkerGroup> markerGroups) {
        this.markerGroups = markerGroups;
    }

    public SignLinesParseResult parse(String[] lines) {
        ParseStates state = ParseStates.START;
        ParsingContext context = new ParsingContext();
        for (String line : lines) {
            line = line.trim();
            if (state == ParseStates.START) {
                state = SignLinesParser.processStartState(line, context, this.markerGroups);
                continue;
            }
            if (state != ParseStates.HAS_MARKER_TYPE) continue;
            SignLinesParser.processHasMarkerType(line, context);
        }
        return state == ParseStates.INVALID ? new SignLinesParseResult(null, "", "") : context.buildResult();
    }

    private static ParseStates processStartState(String line, ParsingContext context, List<MarkerGroup> markerGroups) {
        if (line.isEmpty()) {
            return ParseStates.START;
        }
        context.setMarkerGroup(SignLinesParser.getMarkerGroup(line, markerGroups));
        if (context.getMarkerGroup() == null) {
            return ParseStates.INVALID;
        }
        context.setLabel(line.substring(context.getMarkerGroup().prefix().length()).trim());
        if (!context.getLabel().isEmpty()) {
            context.appendDetail(context.getLabel());
        }
        return ParseStates.HAS_MARKER_TYPE;
    }

    private static void processHasMarkerType(String line, ParsingContext context) {
        if (line.isEmpty()) {
            return;
        }
        if (context.getLabel().isEmpty()) {
            context.setLabel(line);
        }
        context.appendDetail(line);
    }

    private static MarkerGroup getMarkerGroup(String line, List<MarkerGroup> markerGroups) {
        return markerGroups.stream().filter(markerGroup -> line.startsWith(markerGroup.prefix())).findFirst().orElse(null);
    }

    private static enum ParseStates {
        START,
        HAS_MARKER_TYPE,
        INVALID;

    }
}

