/*
 * Decompiled with CFR 0.152.
 */
package com.tpwalke2.bluemapsignmarkers.core.signs;

import com.tpwalke2.bluemapsignmarkers.config.ConfigManager;
import com.tpwalke2.bluemapsignmarkers.core.bluemap.BlueMapAPIConnector;
import com.tpwalke2.bluemapsignmarkers.core.bluemap.IResetHandler;
import com.tpwalke2.bluemapsignmarkers.core.bluemap.actions.ActionFactory;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerGroup;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerGroupType;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerSetIdentifierCollection;
import com.tpwalke2.bluemapsignmarkers.core.signs.SignEntry;
import com.tpwalke2.bluemapsignmarkers.core.signs.SignEntryHelper;
import com.tpwalke2.bluemapsignmarkers.core.signs.SignEntryKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignManager
implements IResetHandler {
    private static SignManager instance;
    private static final Object mutex;
    private static final Logger LOGGER;
    private final BlueMapAPIConnector blueMapAPIConnector;
    private final ActionFactory actionFactory;
    private final ConcurrentMap<SignEntryKey, SignEntry> signCache = new ConcurrentHashMap<SignEntryKey, SignEntry>();
    private final Map<String, MarkerGroup> prefixGroupMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SignManager getInstance() {
        SignManager result = instance;
        if (result == null) {
            Object object = mutex;
            synchronized (object) {
                result = instance;
                if (result == null) {
                    instance = result = new SignManager();
                }
            }
        }
        return result;
    }

    public static void addOrUpdate(SignEntry signEntry) {
        SignManager.getInstance().addOrUpdateSign(signEntry);
    }

    public static void remove(SignEntryKey key) {
        SignManager.getInstance().removeByKey(key);
    }

    public static List<SignEntry> getAll() {
        return SignManager.getInstance().getAllSigns();
    }

    public static void stop() {
        SignManager.getInstance().shutdown();
    }

    private SignManager() {
        MarkerGroup[] groups = ConfigManager.get().getMarkerGroups();
        this.prefixGroupMap = new TreeMap<String, MarkerGroup>();
        for (MarkerGroup group : groups) {
            if (this.prefixGroupMap.containsKey(group.prefix())) {
                LOGGER.warn("Duplicate marker group prefix found: {}", (Object)group.prefix());
                continue;
            }
            this.prefixGroupMap.put(group.prefix(), group);
        }
        MarkerSetIdentifierCollection markerSetIdentifierCollection = new MarkerSetIdentifierCollection();
        this.actionFactory = new ActionFactory(markerSetIdentifierCollection);
        this.blueMapAPIConnector = new BlueMapAPIConnector();
        this.blueMapAPIConnector.addResetHandler(this);
    }

    private List<SignEntry> getAllSigns() {
        return new ArrayList<SignEntry>(this.signCache.values());
    }

    private void shutdown() {
        this.blueMapAPIConnector.shutdown();
    }

    private void reloadSigns() {
        LOGGER.info("Reloading all signs...");
        List<SignEntry> existingSigns = this.getAllSigns();
        this.signCache.clear();
        for (SignEntry signEntry : existingSigns) {
            this.addOrUpdateSign(signEntry);
        }
    }

    private void addOrUpdateSign(SignEntry signEntry) {
        SignEntryKey key = signEntry.key();
        SignEntry existing = (SignEntry)this.signCache.get(key);
        boolean isPOIMarker = SignEntryHelper.isMarkerType(signEntry, this.prefixGroupMap, MarkerGroupType.POI);
        String label = SignEntryHelper.getLabel(signEntry);
        String detail = SignEntryHelper.getDetail(signEntry);
        String prefix = SignEntryHelper.getPrefix(signEntry);
        if (prefix == null) {
            LOGGER.debug("Cannot add or update sign as no prefix found: {}", (Object)signEntry);
            return;
        }
        if (existing == null && isPOIMarker) {
            LOGGER.debug("Adding POI marker: {}", (Object)signEntry);
            this.signCache.put(key, signEntry);
            this.blueMapAPIConnector.dispatch(this.actionFactory.createAddPOIAction(key.x(), key.y(), key.z(), key.parentMap(), label, detail, this.prefixGroupMap.get(prefix)));
            return;
        }
        if (existing != null && !isPOIMarker) {
            LOGGER.debug("Removing POI marker: {}", (Object)signEntry);
            this.removeEntry(signEntry);
        }
        if (existing != null && isPOIMarker) {
            LOGGER.debug("Updating POI marker: {}", (Object)signEntry);
            if (signEntry.playerId().equals("unknown")) {
                this.signCache.put(key, new SignEntry(key, existing.playerId(), signEntry.frontText(), signEntry.backText()));
            } else {
                this.signCache.put(key, signEntry);
            }
            this.blueMapAPIConnector.dispatch(this.actionFactory.createUpdatePOIAction(key.x(), key.y(), key.z(), key.parentMap(), label, detail, this.prefixGroupMap.get(prefix)));
        }
    }

    private void removeByKey(SignEntryKey key) {
        SignEntry removed = (SignEntry)this.signCache.remove(key);
        if (removed == null) {
            LOGGER.debug("No sign found for key: {}", (Object)key);
            return;
        }
        String prefix = SignEntryHelper.getPrefix(removed);
        if (prefix == null) {
            LOGGER.debug("Cannot remove sign as no prefix found: {}", (Object)removed);
            return;
        }
        this.blueMapAPIConnector.dispatch(this.actionFactory.createRemovePOIAction(key.x(), key.y(), key.z(), key.parentMap(), this.prefixGroupMap.get(prefix)));
    }

    private void removeEntry(SignEntry signEntry) {
        this.removeByKey(signEntry.key());
    }

    @Override
    public void reset() {
        this.reloadSigns();
    }

    static {
        mutex = new Object();
        LOGGER = LoggerFactory.getLogger((String)"bluemapsignmarkers");
    }
}

