/*
 * Decompiled with CFR 0.152.
 */
package com.tpwalke2.bluemapsignmarkers.core.signs.persistence.loaders;

import com.google.gson.Gson;
import com.tpwalke2.bluemapsignmarkers.common.FileUtils;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerGroup;
import com.tpwalke2.bluemapsignmarkers.core.signs.SignEntry;
import com.tpwalke2.bluemapsignmarkers.core.signs.SignEntryKey;
import com.tpwalke2.bluemapsignmarkers.core.signs.persistence.loaders.Version3Converter;
import com.tpwalke2.bluemapsignmarkers.core.signs.persistence.models.SignEntryV2;
import java.util.Arrays;
import net.minecraft.class_1937;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version1SignEntryLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"bluemapsignmarkers");
    private static final String NETHER = "nether";
    private static final String END = "end";
    private static final String OVERWORLD = "overworld";

    private Version1SignEntryLoader() {
    }

    public static SignEntry[] loadSignEntries(String path, String signsContent, MarkerGroup[] markerGroups, Gson gson) {
        LOGGER.info("Loading version 1 markers file...");
        SignEntry[] signEntries = (SignEntry[])Arrays.stream((SignEntryV2[])gson.fromJson(signsContent, SignEntryV2[].class)).map(Version1SignEntryLoader::withNormalizedKey).map(entry -> Version3Converter.convertToV3(entry, markerGroups)).toArray(SignEntry[]::new);
        FileUtils.createBackup(path, ".v1.bak", "markers file");
        return signEntries;
    }

    private static SignEntryV2 withNormalizedKey(SignEntryV2 entry) {
        return entry.withKey(Version1SignEntryLoader.withNormalizedMapId(entry.key()));
    }

    private static SignEntryKey withNormalizedMapId(SignEntryKey key) {
        return key.withParentMap(Version1SignEntryLoader.getNormalizedMapId(key.parentMap()));
    }

    private static String getNormalizedMapId(String mapId) {
        String result;
        return switch (result = mapId.toLowerCase()) {
            case NETHER -> class_1937.field_25180.method_29177().toString();
            case END -> class_1937.field_25181.method_29177().toString();
            case OVERWORLD -> class_1937.field_25179.method_29177().toString();
            default -> result;
        };
    }
}

