/*
 * Decompiled with CFR 0.152.
 */
package com.tpwalke2.bluemapsignmarkers.core.signs.persistence.loaders;

import com.google.gson.Gson;
import com.tpwalke2.bluemapsignmarkers.common.FileUtils;
import com.tpwalke2.bluemapsignmarkers.core.markers.MarkerGroup;
import com.tpwalke2.bluemapsignmarkers.core.signs.SignEntry;
import com.tpwalke2.bluemapsignmarkers.core.signs.persistence.SignFileVersions;
import com.tpwalke2.bluemapsignmarkers.core.signs.persistence.VersionedSignFile;
import com.tpwalke2.bluemapsignmarkers.core.signs.persistence.loaders.Version3Converter;
import com.tpwalke2.bluemapsignmarkers.core.signs.persistence.models.SignEntryV2;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionedFileSignEntryLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"bluemapsignmarkers");

    private VersionedFileSignEntryLoader() {
    }

    public static SignEntry[] loadSignEntries(String path, String content, MarkerGroup[] markerGroups, Gson gson) {
        try {
            VersionedSignFile versionedSignFile = (VersionedSignFile)gson.fromJson(content, VersionedSignFile.class);
            if (versionedSignFile.version() == SignFileVersions.V2) {
                LOGGER.info("Loading version 2 markers file...");
                SignEntry[] signEntries = (SignEntry[])Arrays.stream((SignEntryV2[])gson.fromJson(versionedSignFile.data(), SignEntryV2[].class)).map(entry -> Version3Converter.convertToV3(entry, markerGroups)).toArray(SignEntry[]::new);
                FileUtils.createBackup(path, ".v2.bak", "markers file");
                return signEntries;
            }
            LOGGER.info("Loading version 3+ markers file...");
            return (SignEntry[])gson.fromJson(versionedSignFile.data(), SignEntry[].class);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load versioned sign file, falling back to version 1");
            return null;
        }
    }
}

