/*
 * Decompiled with CFR 0.152.
 */
package dev.codedsakura.blossom.lib.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.codedsakura.blossom.lib.BlossomGlobals;
import dev.codedsakura.blossom.lib.utils.CubicBezierCurve;
import dev.codedsakura.blossom.lib.utils.gson.CubicBezierCurveSerializer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;

public class BlossomConfig {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(CubicBezierCurve.class, (Object)new CubicBezierCurveSerializer()).setPrettyPrinting().serializeNulls().disableHtmlEscaping().create();

    private static File getFile(String filename) {
        return FabricLoader.getInstance().getConfigDir().resolve("BlossomMods/" + filename).toFile();
    }

    @NotNull
    public static <T> T load(Class<T> clazz, String filename) {
        Optional.ofNullable(BlossomGlobals.LOGGER).ifPresent(l -> l.trace("loading config {}", (Object)filename));
        File file = BlossomConfig.getFile(filename);
        Object config = null;
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                config = GSON.fromJson((Reader)reader, clazz);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (config == null) {
            try {
                config = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        BlossomConfig.save(config, filename);
        return (T)config;
    }

    public static <T> void save(T config, String filename) {
        Optional.ofNullable(BlossomGlobals.LOGGER).ifPresent(l -> l.trace("saving config {}", (Object)filename));
        File file = BlossomConfig.getFile(filename);
        if (!file.getParentFile().exists() && !file.getParentFile().mkdir()) {
            System.err.println("Failed to create a directory for " + file);
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(file));){
            GSON.toJson(config, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

