/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio;

import io.ktor.http.cio.HttpHeadersMap;
import io.ktor.http.cio.HttpHeadersMapKt;
import io.ktor.http.cio.internals.CharArrayBuilder;
import io.ktor.http.cio.internals.CharsKt;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b*\u0010+J\u001f\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0003\u001a\u00020\u0002H\u0086\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u000b2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J=\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001e\u0010\u0010R\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0016\u0010#\u001a\u00020\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R$\u0010&\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00048\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b&\u0010'\u001a\u0004\b(\u0010)\u00a8\u0006,"}, d2={"Lio/ktor/http/cio/HttpHeadersMap;", "", "", "name", "", "fromIndex", "find", "(Ljava/lang/String;I)I", "", "get", "(Ljava/lang/String;)Ljava/lang/CharSequence;", "Lkotlin/sequences/Sequence;", "getAll", "(Ljava/lang/String;)Lkotlin/sequences/Sequence;", "idx", "nameAt", "(I)Ljava/lang/CharSequence;", "nameHash", "valueHash", "nameStartIndex", "nameEndIndex", "valueStartIndex", "valueEndIndex", "", "put", "(IIIIII)V", "release", "()V", "toString", "()Ljava/lang/String;", "valueAt", "Lio/ktor/http/cio/internals/CharArrayBuilder;", "builder", "Lio/ktor/http/cio/internals/CharArrayBuilder;", "", "indexes", "[I", "<set-?>", "size", "I", "getSize", "()I", "<init>", "(Lio/ktor/http/cio/internals/CharArrayBuilder;)V", "ktor-http-cio"})
@SourceDebugExtension(value={"SMAP\nHttpHeadersMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpHeadersMap.kt\nio/ktor/http/cio/HttpHeadersMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1#2:150\n*E\n"})
public final class HttpHeadersMap {
    @NotNull
    private final CharArrayBuilder builder;
    private int size;
    @NotNull
    private int[] indexes;

    public HttpHeadersMap(@NotNull CharArrayBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.builder = builder;
        this.indexes = (int[])HttpHeadersMapKt.access$getIntArrayPool$p().borrow();
    }

    public final int getSize() {
        return this.size;
    }

    public final void put(int nameHash, int valueHash, int nameStartIndex, int nameEndIndex, int valueStartIndex, int valueEndIndex) {
        int base = this.size * 8;
        int[] array = this.indexes;
        if (base >= this.indexes.length) {
            String string = "Implement headers overflow";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        array[base + 0] = nameHash;
        array[base + 1] = valueHash;
        array[base + 2] = nameStartIndex;
        array[base + 3] = nameEndIndex;
        array[base + 4] = valueStartIndex;
        array[base + 5] = valueEndIndex;
        array[base + 6] = -1;
        array[base + 7] = -1;
        int n = this.size;
        this.size = n + 1;
    }

    public final int find(@NotNull String name, int fromIndex) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int nameHash = CharsKt.hashCodeLowerCase$default(name, 0, 0, 3, null);
        int n = this.size;
        for (int i = fromIndex; i < n; ++i) {
            int offset = i * 8;
            if (this.indexes[offset] != nameHash) continue;
            return i;
        }
        return -1;
    }

    public static /* synthetic */ int find$default(HttpHeadersMap httpHeadersMap, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return httpHeadersMap.find(string, n);
    }

    @Nullable
    public final CharSequence get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int nameHash = CharsKt.hashCodeLowerCase$default(name, 0, 0, 3, null);
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            int offset = i * 8;
            if (this.indexes[offset] != nameHash) continue;
            return this.builder.subSequence(this.indexes[offset + 4], this.indexes[offset + 5]);
        }
        return null;
    }

    @NotNull
    public final Sequence<CharSequence> getAll(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int nameHash = CharsKt.hashCodeLowerCase$default(name, 0, 0, 3, null);
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)0, (Function1)((Function1)new Function1<Integer, Integer>(this){
            final /* synthetic */ HttpHeadersMap this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final Integer invoke(int it) {
                return it + 1 >= this.this$0.getSize() ? null : Integer.valueOf(it + 1);
            }
        })), (Function1)getAll.2.INSTANCE), (Function1)((Function1)new Function1<Integer, Boolean>(this, nameHash){
            final /* synthetic */ HttpHeadersMap this$0;
            final /* synthetic */ int $nameHash;
            {
                this.this$0 = $receiver;
                this.$nameHash = $nameHash;
                super(1);
            }

            @NotNull
            public final Boolean invoke(int it) {
                return HttpHeadersMap.access$getIndexes$p(this.this$0)[it] == this.$nameHash;
            }
        })), (Function1)((Function1)new Function1<Integer, CharSequence>(this){
            final /* synthetic */ HttpHeadersMap this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(int it) {
                return HttpHeadersMap.access$getBuilder$p(this.this$0).subSequence(HttpHeadersMap.access$getIndexes$p(this.this$0)[it + 4], HttpHeadersMap.access$getIndexes$p(this.this$0)[it + 5]);
            }
        }));
    }

    @NotNull
    public final CharSequence nameAt(int idx) {
        if (!(idx >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(idx < this.size)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int offset = idx * 8;
        int[] array = this.indexes;
        int nameStart = array[offset + 2];
        int nameEnd = array[offset + 3];
        return this.builder.subSequence(nameStart, nameEnd);
    }

    @NotNull
    public final CharSequence valueAt(int idx) {
        if (!(idx >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(idx < this.size)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int offset = idx * 8;
        int[] array = this.indexes;
        int nameStart = array[offset + 4];
        int nameEnd = array[offset + 5];
        return this.builder.subSequence(nameStart, nameEnd);
    }

    public final void release() {
        this.size = 0;
        int[] indexes = this.indexes;
        this.indexes = HttpHeadersMapKt.access$getEMPTY_INT_LIST$p();
        if (indexes != HttpHeadersMapKt.access$getEMPTY_INT_LIST$p()) {
            HttpHeadersMapKt.access$getIntArrayPool$p().recycle(indexes);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        HttpHeadersMapKt.dumpTo(this, "", $this$toString_u24lambda_u240);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static final /* synthetic */ int[] access$getIndexes$p(HttpHeadersMap $this) {
        return $this.indexes;
    }

    public static final /* synthetic */ CharArrayBuilder access$getBuilder$p(HttpHeadersMap $this) {
        return $this.builder;
    }
}

