/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.config;

import io.ktor.server.config.ApplicationConfig;
import io.ktor.server.config.ApplicationConfigValue;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u000f\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0014\u001a\u00020\u0001\u0012\u0006\u0010\u001c\u001a\u00020\u0001\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u001d\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u000bR\u0017\u0010\u001c\u001a\u00020\u00018\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0015\u001a\u0004\b\u001d\u0010\u0017\u00a8\u0006 "}, d2={"Lio/ktor/server/config/MergedApplicationConfig;", "Lio/ktor/server/config/ApplicationConfig;", "", "path", "config", "(Ljava/lang/String;)Lio/ktor/server/config/ApplicationConfig;", "", "configList", "(Ljava/lang/String;)Ljava/util/List;", "", "keys", "()Ljava/util/Set;", "Lio/ktor/server/config/ApplicationConfigValue;", "property", "(Ljava/lang/String;)Lio/ktor/server/config/ApplicationConfigValue;", "propertyOrNull", "", "", "toMap", "()Ljava/util/Map;", "first", "Lio/ktor/server/config/ApplicationConfig;", "getFirst", "()Lio/ktor/server/config/ApplicationConfig;", "firstKeys$delegate", "Lkotlin/Lazy;", "getFirstKeys", "firstKeys", "second", "getSecond", "<init>", "(Lio/ktor/server/config/ApplicationConfig;Lio/ktor/server/config/ApplicationConfig;)V", "ktor-server-core"})
public final class MergedApplicationConfig
implements ApplicationConfig {
    @NotNull
    private final ApplicationConfig first;
    @NotNull
    private final ApplicationConfig second;
    @NotNull
    private final Lazy firstKeys$delegate;

    public MergedApplicationConfig(@NotNull ApplicationConfig first, @NotNull ApplicationConfig second2) {
        Intrinsics.checkNotNullParameter((Object)first, (String)"first");
        Intrinsics.checkNotNullParameter((Object)second2, (String)"second");
        this.first = first;
        this.second = second2;
        this.firstKeys$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends String>>(this){
            final /* synthetic */ MergedApplicationConfig this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<String> invoke() {
                return this.this$0.getFirst().keys();
            }
        }));
    }

    @NotNull
    public final ApplicationConfig getFirst() {
        return this.first;
    }

    @NotNull
    public final ApplicationConfig getSecond() {
        return this.second;
    }

    private final Set<String> getFirstKeys() {
        Lazy lazy = this.firstKeys$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public ApplicationConfigValue property(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.getFirstKeys().contains(path) ? this.first.property(path) : this.second.property(path);
    }

    @Override
    @Nullable
    public ApplicationConfigValue propertyOrNull(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.getFirstKeys().contains(path) ? this.first.propertyOrNull(path) : this.second.propertyOrNull(path);
    }

    @Override
    @NotNull
    public ApplicationConfig config(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new MergedApplicationConfig(this.first.config(path), this.second.config(path));
    }

    @Override
    @NotNull
    public List<ApplicationConfig> configList(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        List<ApplicationConfig> firstList = this.getFirstKeys().contains(path) ? this.first.configList(path) : CollectionsKt.emptyList();
        List<ApplicationConfig> secondList = this.second.keys().contains(path) ? this.second.configList(path) : CollectionsKt.emptyList();
        return CollectionsKt.plus((Collection)firstList, (Iterable)secondList);
    }

    @Override
    @NotNull
    public Set<String> keys() {
        return SetsKt.plus(this.getFirstKeys(), (Iterable)this.second.keys());
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        return MapsKt.plus(this.second.toMap(), this.first.toMap());
    }
}

