/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.converters;

import io.ktor.util.converters.ConversionService;
import io.ktor.util.reflect.TypeInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0018Bm\u0012\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0013\u0012+\u0010\u0010\u001a'\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\r\u0012+\u0010\u0012\u001a'\u0012\u0015\u0012\u0013\u0018\u00010\u0007\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0018\u00010\r\u00a2\u0006\u0004\b\u0016\u0010\u0017J'\u0010\b\u001a\u0004\u0018\u00010\u00072\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR9\u0010\u0010\u001a'\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0018\u00010\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R9\u0010\u0012\u001a'\u0012\u0015\u0012\u0013\u0018\u00010\u0007\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0018\u00010\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0011R\u0018\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00138\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lio/ktor/util/converters/DelegatingConversionService;", "Lio/ktor/util/converters/ConversionService;", "", "", "values", "Lio/ktor/util/reflect/TypeInfo;", "type", "", "fromValues", "(Ljava/util/List;Lio/ktor/util/reflect/TypeInfo;)Ljava/lang/Object;", "value", "toValues", "(Ljava/lang/Object;)Ljava/util/List;", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "decoder", "Lkotlin/jvm/functions/Function1;", "encoder", "Lkotlin/reflect/KClass;", "klass", "Lkotlin/reflect/KClass;", "<init>", "(Lkotlin/reflect/KClass;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "Configuration", "ktor-utils"})
public final class DelegatingConversionService
implements ConversionService {
    @NotNull
    private final KClass<?> klass;
    @Nullable
    private final Function1<List<String>, Object> decoder;
    @Nullable
    private final Function1<Object, List<String>> encoder;

    public DelegatingConversionService(@NotNull KClass<?> klass, @Nullable Function1<? super List<String>, ? extends Object> decoder, @Nullable Function1<Object, ? extends List<String>> encoder2) {
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        this.klass = klass;
        this.decoder = decoder;
        this.encoder = encoder2;
    }

    @Override
    @Nullable
    public Object fromValues(@NotNull List<String> values, @NotNull TypeInfo type) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Function1<List<String>, Object> function1 = this.decoder;
        if (function1 == null) {
            throw new IllegalStateException("Decoder was not specified for type '" + this.klass + '\'');
        }
        Function1<List<String>, Object> currentDecoder = function1;
        return currentDecoder.invoke(values);
    }

    @Override
    @NotNull
    public List<String> toValues(@Nullable Object value) {
        Function1<Object, List<String>> function1 = this.encoder;
        if (function1 == null) {
            throw new IllegalStateException("Encoder was not specified for type '" + this.klass + '\'');
        }
        Function1<Object, List<String>> currentDecoder = function1;
        return (List)currentDecoder.invoke(value);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001B\u0017\b\u0001\u0012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001dJ6\u0010\u000b\u001a\u00020\n2'\u0010\t\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ6\u0010\u000e\u001a\u00020\n2'\u0010\t\u001a#\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0004\b\u000e\u0010\fRE\u0010\u000f\u001a%\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00038\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\fRE\u0010\u0014\u001a%\u0012\u0013\u0012\u00118\u0000\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0018\u00010\u00038\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0010\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\fR \u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u00178\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lio/ktor/util/converters/DelegatingConversionService$Configuration;", "", "T", "Lkotlin/Function1;", "", "", "Lkotlin/ParameterName;", "name", "values", "converter", "", "decode", "(Lkotlin/jvm/functions/Function1;)V", "value", "encode", "decoder", "Lkotlin/jvm/functions/Function1;", "getDecoder$ktor_utils", "()Lkotlin/jvm/functions/Function1;", "setDecoder$ktor_utils", "encoder", "getEncoder$ktor_utils", "setEncoder$ktor_utils", "Lkotlin/reflect/KClass;", "klass", "Lkotlin/reflect/KClass;", "getKlass$ktor_utils", "()Lkotlin/reflect/KClass;", "<init>", "(Lkotlin/reflect/KClass;)V", "ktor-utils"})
    public static final class Configuration<T> {
        @NotNull
        private final KClass<T> klass;
        @Nullable
        private Function1<? super List<String>, ? extends T> decoder;
        @Nullable
        private Function1<? super T, ? extends List<String>> encoder;

        @PublishedApi
        public Configuration(@NotNull KClass<T> klass) {
            Intrinsics.checkNotNullParameter(klass, (String)"klass");
            this.klass = klass;
        }

        @NotNull
        public final KClass<T> getKlass$ktor_utils() {
            return this.klass;
        }

        @Nullable
        public final Function1<List<String>, T> getDecoder$ktor_utils() {
            return this.decoder;
        }

        public final void setDecoder$ktor_utils(@Nullable Function1<? super List<String>, ? extends T> function1) {
            this.decoder = function1;
        }

        @Nullable
        public final Function1<T, List<String>> getEncoder$ktor_utils() {
            return this.encoder;
        }

        public final void setEncoder$ktor_utils(@Nullable Function1<? super T, ? extends List<String>> function1) {
            this.encoder = function1;
        }

        public final void decode(@NotNull Function1<? super List<String>, ? extends T> converter) {
            Intrinsics.checkNotNullParameter(converter, (String)"converter");
            if (this.decoder != null) {
                throw new IllegalStateException("Decoder has already been set for type '" + this.klass + '\'');
            }
            this.decoder = converter;
        }

        public final void encode(@NotNull Function1<? super T, ? extends List<String>> converter) {
            Intrinsics.checkNotNullParameter(converter, (String)"converter");
            if (this.encoder != null) {
                throw new IllegalStateException("Encoder has already been set for type '" + this.klass + '\'');
            }
            this.encoder = converter;
        }
    }
}

