/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.utils.io.internal;

import io.ktor.utils.io.ByteBufferChannel;
import io.ktor.utils.io.SuspendableReadSession;
import io.ktor.utils.io.core.Buffer;
import io.ktor.utils.io.core.BufferUtilsJvmKt;
import io.ktor.utils.io.core.internal.ChunkBuffer;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001b\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\b\u0010\fJ\u0017\u0010\u000e\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\u00020\n8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001e"}, d2={"Lio/ktor/utils/io/internal/ReadSessionImpl;", "Lio/ktor/utils/io/SuspendableReadSession;", "", "atLeast", "", "await", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "completed", "()V", "Lio/ktor/utils/io/core/internal/ChunkBuffer;", "newView", "(Lio/ktor/utils/io/core/internal/ChunkBuffer;)V", "n", "discard", "(I)I", "request", "(I)Lio/ktor/utils/io/core/internal/ChunkBuffer;", "getAvailableForRead", "()I", "availableForRead", "Lio/ktor/utils/io/ByteBufferChannel;", "channel", "Lio/ktor/utils/io/ByteBufferChannel;", "lastAvailable", "I", "lastView", "Lio/ktor/utils/io/core/internal/ChunkBuffer;", "<init>", "(Lio/ktor/utils/io/ByteBufferChannel;)V", "ktor-io"})
@SourceDebugExtension(value={"SMAP\nReadSessionImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReadSessionImpl.kt\nio/ktor/utils/io/internal/ReadSessionImpl\n+ 2 Buffer.kt\nio/ktor/utils/io/core/Buffer\n*L\n1#1,47:1\n66#2:48\n66#2:49\n*S KotlinDebug\n*F\n+ 1 ReadSessionImpl.kt\nio/ktor/utils/io/internal/ReadSessionImpl\n*L\n17#1:48\n22#1:49\n*E\n"})
public final class ReadSessionImpl
implements SuspendableReadSession {
    @NotNull
    private final ByteBufferChannel channel;
    private int lastAvailable;
    @NotNull
    private ChunkBuffer lastView;

    public ReadSessionImpl(@NotNull ByteBufferChannel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.channel = channel;
        this.lastView = ChunkBuffer.Companion.getEmpty();
    }

    public final void completed() {
        this.completed(ChunkBuffer.Companion.getEmpty());
    }

    private final void completed(ChunkBuffer newView) {
        Buffer this_$iv = this.lastView;
        boolean $i$f$getReadRemaining = false;
        int delta = this.lastAvailable - (this_$iv.getWritePosition() - this_$iv.getReadPosition());
        if (delta > 0) {
            this.channel.consumed(delta);
        }
        this.lastView = newView;
        this_$iv = newView;
        $i$f$getReadRemaining = false;
        this.lastAvailable = this_$iv.getWritePosition() - this_$iv.getReadPosition();
    }

    @Override
    public int getAvailableForRead() {
        return this.channel.getAvailableForRead();
    }

    @Override
    public int discard(int n) {
        this.completed();
        int quantity = Math.min(this.getAvailableForRead(), n);
        this.channel.consumed(quantity);
        return quantity;
    }

    @Override
    @Nullable
    public ChunkBuffer request(int atLeast) {
        ChunkBuffer chunkBuffer;
        ByteBuffer byteBuffer = this.channel.request(0, atLeast);
        if (byteBuffer != null) {
            ChunkBuffer chunkBuffer2;
            ByteBuffer it = byteBuffer;
            boolean bl = false;
            ChunkBuffer it2 = chunkBuffer2 = BufferUtilsJvmKt.ChunkBuffer$default(it, null, 2, null);
            boolean bl2 = false;
            it2.resetForRead();
            this.completed(it2);
            chunkBuffer = chunkBuffer2;
        } else {
            chunkBuffer = null;
        }
        return chunkBuffer;
    }

    @Override
    @Nullable
    public Object await(int atLeast, @NotNull Continuation<? super Boolean> $completion) {
        this.completed();
        return this.channel.awaitAtLeast(atLeast, $completion);
    }
}

