/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.css;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.css.Color;
import kotlinx.css.FlexBasis;
import kotlinx.css.LinearDimension;
import kotlinx.css.QuotedString;
import kotlinx.css.VerticalAlign;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000:\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0001\u001a\u00020\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0015\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000b\u001a%\u0010\u000f\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a-\u0010\u0011\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a%\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b\u00a2\u0006\u0004\b\u0016\u0010\u0010\u001a-\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0012\u001a\u0015\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0004\u001a\u0013\u0010\u0019\u001a\u00020\u0005*\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001a\"\u0015\u0010\u001f\u001a\u00020\u001c*\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\"\u0015\u0010#\u001a\u00020 *\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\"\u0015\u0010'\u001a\u00020$*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\"\u0015\u0010)\u001a\u00020 *\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\"\u00a8\u0006*"}, d2={"", "alpha", "Lkotlinx/css/Color;", "blackAlpha", "(D)Lkotlinx/css/Color;", "", "formatAlpha", "(D)Ljava/lang/String;", "", "value", "hex", "(I)Lkotlinx/css/Color;", "hue", "saturation", "lightness", "hsl", "(III)Lkotlinx/css/Color;", "hsla", "(IIID)Lkotlinx/css/Color;", "red", "green", "blue", "rgb", "rgba", "whiteAlpha", "withZeros", "(Ljava/lang/String;)Ljava/lang/String;", "Lkotlinx/css/LinearDimension;", "Lkotlinx/css/FlexBasis;", "getBasis", "(Lkotlinx/css/LinearDimension;)Lkotlinx/css/FlexBasis;", "basis", "Lkotlinx/css/VerticalAlign;", "getDown", "(Lkotlinx/css/LinearDimension;)Lkotlinx/css/VerticalAlign;", "down", "Lkotlinx/css/QuotedString;", "getQuoted", "(Ljava/lang/String;)Lkotlinx/css/QuotedString;", "quoted", "getUp", "up", "kotlin-css"})
public final class StyleEnumsKt {
    private static final String withZeros(String $this$withZeros) {
        return $this$withZeros + StringsKt.repeat((CharSequence)"0", (int)Math.max(0, 3 - $this$withZeros.length()));
    }

    @NotNull
    public static final Color hex(int value) {
        String string = Integer.toString(value, CharsKt.checkRadix((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(this, checkRadix(radix))");
        return new Color("#" + StyleEnumsKt.withZeros(string));
    }

    @NotNull
    public static final Color rgb(int red, int green, int blue) {
        return new Color("rgb(" + red + ", " + green + ", " + blue + ")");
    }

    @NotNull
    public static final Color rgba(int red, int green, int blue, double alpha) {
        return new Color("rgba(" + red + ", " + green + ", " + blue + ", " + StyleEnumsKt.formatAlpha(alpha) + ")");
    }

    @NotNull
    public static final Color hsl(int hue, int saturation, int lightness) {
        return new Color("hsl(" + hue + ", " + saturation + "%, " + lightness + "%)");
    }

    @NotNull
    public static final Color hsla(int hue, int saturation, int lightness, double alpha) {
        return new Color("hsla(" + hue + ", " + saturation + "%, " + lightness + "%, " + StyleEnumsKt.formatAlpha(alpha) + ")");
    }

    @NotNull
    public static final Color blackAlpha(double alpha) {
        return Color.Companion.getBlack().withAlpha(alpha);
    }

    @NotNull
    public static final Color whiteAlpha(double alpha) {
        return Color.Companion.getWhite().withAlpha(alpha);
    }

    private static final String formatAlpha(double alpha) {
        String it = String.valueOf(alpha);
        boolean bl = false;
        return StringsKt.contains$default((CharSequence)it, (CharSequence)".", (boolean)false, (int)2, null) ? it : it + ".0";
    }

    @NotNull
    public static final QuotedString getQuoted(@NotNull String $this$quoted) {
        Intrinsics.checkNotNullParameter((Object)$this$quoted, (String)"<this>");
        return new QuotedString($this$quoted);
    }

    @NotNull
    public static final FlexBasis getBasis(@NotNull LinearDimension $this$basis) {
        Intrinsics.checkNotNullParameter((Object)$this$basis, (String)"<this>");
        return new FlexBasis($this$basis.toString());
    }

    @NotNull
    public static final VerticalAlign getUp(@NotNull LinearDimension $this$up) {
        Intrinsics.checkNotNullParameter((Object)$this$up, (String)"<this>");
        return new VerticalAlign($this$up.toString());
    }

    @NotNull
    public static final VerticalAlign getDown(@NotNull LinearDimension $this$down) {
        Intrinsics.checkNotNullParameter((Object)$this$down, (String)"<this>");
        return new VerticalAlign($this$down.unaryMinus().toString());
    }
}

