/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.lang.annotation.Annotation;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SealedClassSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.internal.JsonInternalDependenciesKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonClassDiscriminator;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.TreeJsonDecoderKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0017\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\u001a!\u0010\n\u001a\u00020\t2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0001\u00a2\u0006\u0004\b\n\u0010\u000b\u001a1\u0010\u0011\u001a\u00020\u00022\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u001a\u001b\u0010\u0010\u001a\u00020\u0005*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0014H\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0016\u001a'\u0010\u001b\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u0017*\u00020\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0000\u00a2\u0006\u0004\b\u001b\u0010\u001c\u001aG\u0010!\u001a\u00020\u0002\"\u0004\b\u0000\u0010\u0017*\u00020\u001d2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u001e\u001a\u00028\u00002\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00020\u001fH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b!\u0010\"\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006#"}, d2={"Lkotlinx/serialization/descriptors/SerialKind;", "kind", "", "checkKind", "(Lkotlinx/serialization/descriptors/SerialKind;)V", "", "type", "Lkotlinx/serialization/json/JsonObject;", "jsonTree", "", "throwSerializerNotFound", "(Ljava/lang/String;Lkotlinx/serialization/json/JsonObject;)Ljava/lang/Void;", "Lkotlinx/serialization/SerializationStrategy;", "serializer", "", "actualSerializer", "classDiscriminator", "validateIfSealed", "(Lkotlinx/serialization/SerializationStrategy;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/String;)V", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "Lkotlinx/serialization/json/Json;", "json", "(Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/json/Json;)Ljava/lang/String;", "T", "Lkotlinx/serialization/json/JsonDecoder;", "Lkotlinx/serialization/DeserializationStrategy;", "deserializer", "decodeSerializableValuePolymorphic", "(Lkotlinx/serialization/json/JsonDecoder;Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "Lkotlinx/serialization/json/JsonEncoder;", "value", "Lkotlin/Function1;", "ifPolymorphic", "encodePolymorphically", "(Lkotlinx/serialization/json/JsonEncoder;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "kotlinx-serialization-json"})
public final class PolymorphicKt {
    public static final <T> void encodePolymorphically(@NotNull JsonEncoder $this$encodePolymorphically, @NotNull SerializationStrategy<? super T> serializer2, T value, @NotNull Function1<? super String, Unit> ifPolymorphic) {
        Intrinsics.checkNotNullParameter((Object)$this$encodePolymorphically, (String)"<this>");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        Intrinsics.checkNotNullParameter(ifPolymorphic, (String)"ifPolymorphic");
        boolean $i$f$encodePolymorphically = false;
        if (!(serializer2 instanceof AbstractPolymorphicSerializer) || $this$encodePolymorphically.getJson().getConfiguration().getUseArrayPolymorphism()) {
            serializer2.serialize($this$encodePolymorphically, value);
            return;
        }
        AbstractPolymorphicSerializer casted = (AbstractPolymorphicSerializer)serializer2;
        String baseClassDiscriminator = PolymorphicKt.classDiscriminator(serializer2.getDescriptor(), $this$encodePolymorphically.getJson());
        Encoder encoder2 = $this$encodePolymorphically;
        Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Any");
        SerializationStrategy<T> actualSerializer = PolymorphicSerializerKt.findPolymorphicSerializer(casted, encoder2, value);
        PolymorphicKt.validateIfSealed(casted, actualSerializer, baseClassDiscriminator);
        PolymorphicKt.checkKind(actualSerializer.getDescriptor().getKind());
        ifPolymorphic.invoke((Object)baseClassDiscriminator);
        actualSerializer.serialize($this$encodePolymorphically, value);
    }

    private static final void validateIfSealed(SerializationStrategy<?> serializer2, SerializationStrategy<Object> actualSerializer, String classDiscriminator) {
        if (!(serializer2 instanceof SealedClassSerializer)) {
            return;
        }
        if (JsonInternalDependenciesKt.jsonCachedSerialNames(actualSerializer.getDescriptor()).contains(classDiscriminator)) {
            String baseName = serializer2.getDescriptor().getSerialName();
            String actualName = actualSerializer.getDescriptor().getSerialName();
            throw new IllegalStateException(("Sealed class '" + actualName + "' cannot be serialized as base class '" + baseName + "' because it has property name that conflicts with JSON class discriminator '" + classDiscriminator + "'. You can either change class discriminator in JsonConfiguration, rename property with @SerialName annotation or fall back to array polymorphism").toString());
        }
    }

    public static final void checkKind(@NotNull SerialKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (kind instanceof SerialKind.ENUM) {
            throw new IllegalStateException("Enums cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
        }
        if (kind instanceof PrimitiveKind) {
            throw new IllegalStateException("Primitives cannot be serialized polymorphically with 'type' parameter. You can use 'JsonBuilder.useArrayPolymorphism' instead".toString());
        }
        if (kind instanceof PolymorphicKind) {
            throw new IllegalStateException("Actual serializer for polymorphic cannot be polymorphic itself".toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T decodeSerializableValuePolymorphic(@NotNull JsonDecoder $this$decodeSerializableValuePolymorphic, @NotNull DeserializationStrategy<T> deserializer) {
        void value$iv;
        Intrinsics.checkNotNullParameter((Object)$this$decodeSerializableValuePolymorphic, (String)"<this>");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        if (!(deserializer instanceof AbstractPolymorphicSerializer) || $this$decodeSerializableValuePolymorphic.getJson().getConfiguration().getUseArrayPolymorphism()) {
            return deserializer.deserialize($this$decodeSerializableValuePolymorphic);
        }
        String discriminator = PolymorphicKt.classDiscriminator(deserializer.getDescriptor(), $this$decodeSerializableValuePolymorphic.getJson());
        JsonElement jsonElement = $this$decodeSerializableValuePolymorphic.decodeJsonElement();
        SerialDescriptor descriptor$iv = deserializer.getDescriptor();
        boolean $i$f$cast = false;
        if (!(value$iv instanceof JsonObject)) {
            throw JsonExceptionsKt.JsonDecodingException(-1, "Expected " + Reflection.getOrCreateKotlinClass(JsonObject.class) + " as the serialized body of " + descriptor$iv.getSerialName() + ", but had " + Reflection.getOrCreateKotlinClass(value$iv.getClass()));
        }
        JsonObject jsonTree = (JsonObject)value$iv;
        JsonElement jsonElement2 = (JsonElement)jsonTree.get((Object)discriminator);
        String type = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive(jsonElement2)) != null ? ((JsonPrimitive)jsonElement2).getContent() : null;
        DeserializationStrategy deserializationStrategy = ((AbstractPolymorphicSerializer)deserializer).findPolymorphicSerializerOrNull($this$decodeSerializableValuePolymorphic, type);
        if (deserializationStrategy == null) {
            PolymorphicKt.throwSerializerNotFound(type, jsonTree);
            throw new KotlinNothingValueException();
        }
        DeserializationStrategy actualSerializer = deserializationStrategy;
        return TreeJsonDecoderKt.readPolymorphicJson($this$decodeSerializableValuePolymorphic.getJson(), discriminator, jsonTree, actualSerializer);
    }

    @JvmName(name="throwSerializerNotFound")
    @NotNull
    public static final Void throwSerializerNotFound(@Nullable String type, @NotNull JsonObject jsonTree) {
        Intrinsics.checkNotNullParameter((Object)jsonTree, (String)"jsonTree");
        String suffix = type == null ? "missing class discriminator ('null')" : "class discriminator '" + type + '\'';
        throw JsonExceptionsKt.JsonDecodingException(-1, "Polymorphic serializer was not found for " + suffix, jsonTree.toString());
    }

    @NotNull
    public static final String classDiscriminator(@NotNull SerialDescriptor $this$classDiscriminator, @NotNull Json json) {
        Intrinsics.checkNotNullParameter((Object)$this$classDiscriminator, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        for (Annotation annotation : $this$classDiscriminator.getAnnotations()) {
            if (!(annotation instanceof JsonClassDiscriminator)) continue;
            return ((JsonClassDiscriminator)annotation).discriminator();
        }
        return json.getConfiguration().getClassDiscriminator();
    }
}

