/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.PolymorphicSerializerKt;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementSerializer;
import kotlinx.serialization.json.JsonEncoder;
import kotlinx.serialization.json.internal.Composer;
import kotlinx.serialization.json.internal.ComposerForUnsignedNumbers;
import kotlinx.serialization.json.internal.ComposersKt;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonWriter;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B1\b\u0010\u0012\u0006\u0010]\u001a\u00020\\\u0012\u0006\u0010K\u001a\u00020J\u0012\u0006\u0010P\u001a\u00020O\u0012\u000e\u0010S\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010R\u00a2\u0006\u0004\b^\u0010_B1\u0012\u0006\u0010C\u001a\u00020\b\u0012\u0006\u0010K\u001a\u00020J\u0012\u0006\u0010P\u001a\u00020O\u0012\u0010\u0010S\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010R\u00a2\u0006\u0004\b^\u0010`J\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010!\u001a\u00020\r2\u0006\u0010\f\u001a\u00020 H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u0017\u0010$\u001a\u00020#2\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010&\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010*\u001a\u00020\r2\u0006\u0010)\u001a\u00020(H\u0016\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010-\u001a\u00020\r2\u0006\u0010\f\u001a\u00020,H\u0016\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b/\u00100JA\u00105\u001a\u00020\r\"\b\b\u0000\u00102*\u0002012\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00192\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u0000032\b\u0010\f\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0004\b5\u00106J+\u00107\u001a\u00020\r\"\u0004\b\u0000\u001022\f\u00104\u001a\b\u0012\u0004\u0012\u00028\u0000032\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0004\b7\u00108J\u0017\u0010:\u001a\u00020\r2\u0006\u0010\f\u001a\u000209H\u0016\u00a2\u0006\u0004\b:\u0010;J\u0017\u0010=\u001a\u00020\r2\u0006\u0010\f\u001a\u00020<H\u0016\u00a2\u0006\u0004\b=\u0010>J\u0017\u0010?\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b?\u0010@J\u0017\u0010A\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\bA\u0010@J\u001f\u0010B\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\bB\u0010\u001cR\u0014\u0010C\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bC\u0010DR\u0014\u0010F\u001a\u00020E8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u0016\u0010H\u001a\u00020\u000b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bH\u0010IR\u001a\u0010K\u001a\u00020J8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bK\u0010L\u001a\u0004\bM\u0010NR\u0014\u0010P\u001a\u00020O8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bP\u0010QR\u001e\u0010S\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010R8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bS\u0010TR\u0018\u0010U\u001a\u0004\u0018\u00010<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bU\u0010VR\u001a\u0010X\u001a\u00020W8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\bX\u0010Y\u001a\u0004\bZ\u0010[\u00a8\u0006a"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonEncoder;", "Lkotlinx/serialization/json/JsonEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "descriptor", "Lkotlinx/serialization/encoding/CompositeEncoder;", "beginStructure", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/CompositeEncoder;", "Lkotlinx/serialization/json/internal/Composer;", "composerForUnsignedNumbers", "()Lkotlinx/serialization/json/internal/Composer;", "", "value", "", "encodeBoolean", "(Z)V", "", "encodeByte", "(B)V", "", "encodeChar", "(C)V", "", "encodeDouble", "(D)V", "", "index", "encodeElement", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)Z", "enumDescriptor", "encodeEnum", "(Lkotlinx/serialization/descriptors/SerialDescriptor;I)V", "", "encodeFloat", "(F)V", "Lkotlinx/serialization/encoding/Encoder;", "encodeInline", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Lkotlinx/serialization/encoding/Encoder;", "encodeInt", "(I)V", "Lkotlinx/serialization/json/JsonElement;", "element", "encodeJsonElement", "(Lkotlinx/serialization/json/JsonElement;)V", "", "encodeLong", "(J)V", "encodeNull", "()V", "", "T", "Lkotlinx/serialization/SerializationStrategy;", "serializer", "encodeNullableSerializableElement", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeSerializableValue", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "", "encodeShort", "(S)V", "", "encodeString", "(Ljava/lang/String;)V", "encodeTypeInfo", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "endStructure", "shouldEncodeElementDefault", "composer", "Lkotlinx/serialization/json/internal/Composer;", "Lkotlinx/serialization/json/JsonConfiguration;", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "forceQuoting", "Z", "Lkotlinx/serialization/json/Json;", "json", "Lkotlinx/serialization/json/Json;", "getJson", "()Lkotlinx/serialization/json/Json;", "Lkotlinx/serialization/json/internal/WriteMode;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "", "modeReuseCache", "[Lkotlinx/serialization/json/JsonEncoder;", "polymorphicDiscriminator", "Ljava/lang/String;", "Lkotlinx/serialization/modules/SerializersModule;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "Lkotlinx/serialization/json/internal/JsonWriter;", "output", "<init>", "(Lkotlinx/serialization/json/internal/JsonWriter;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;[Lkotlinx/serialization/json/JsonEncoder;)V", "(Lkotlinx/serialization/json/internal/Composer;Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;[Lkotlinx/serialization/json/JsonEncoder;)V", "kotlinx-serialization-json"})
public final class StreamingJsonEncoder
extends AbstractEncoder
implements JsonEncoder {
    @NotNull
    private final Composer composer;
    @NotNull
    private final Json json;
    @NotNull
    private final WriteMode mode;
    @Nullable
    private final JsonEncoder[] modeReuseCache;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final JsonConfiguration configuration;
    private boolean forceQuoting;
    @Nullable
    private String polymorphicDiscriminator;

    public StreamingJsonEncoder(@NotNull Composer composer, @NotNull Json json, @NotNull WriteMode mode, @Nullable JsonEncoder[] modeReuseCache) {
        Intrinsics.checkNotNullParameter((Object)composer, (String)"composer");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this.composer = composer;
        this.json = json;
        this.mode = mode;
        this.modeReuseCache = modeReuseCache;
        this.serializersModule = this.getJson().getSerializersModule();
        this.configuration = this.getJson().getConfiguration();
        int i = this.mode.ordinal();
        if (this.modeReuseCache != null && (this.modeReuseCache[i] != null || this.modeReuseCache[i] != this)) {
            this.modeReuseCache[i] = this;
        }
    }

    @Override
    @NotNull
    public Json getJson() {
        return this.json;
    }

    public StreamingJsonEncoder(@NotNull JsonWriter output, @NotNull Json json, @NotNull WriteMode mode, @NotNull JsonEncoder[] modeReuseCache) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)modeReuseCache, (String)"modeReuseCache");
        this(ComposersKt.Composer(output, json), json, mode, modeReuseCache);
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    public void encodeJsonElement(@NotNull JsonElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.encodeSerializableValue(JsonElementSerializer.INSTANCE, element);
    }

    @Override
    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return this.configuration.getEncodeDefaults();
    }

    @Override
    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer2, T value) {
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        JsonEncoder $this$encodePolymorphically$iv = this;
        boolean $i$f$encodePolymorphically = false;
        if (!(serializer2 instanceof AbstractPolymorphicSerializer) || $this$encodePolymorphically$iv.getJson().getConfiguration().getUseArrayPolymorphism()) {
            serializer2.serialize($this$encodePolymorphically$iv, value);
        } else {
            AbstractPolymorphicSerializer casted$iv = (AbstractPolymorphicSerializer)serializer2;
            String baseClassDiscriminator$iv = PolymorphicKt.classDiscriminator(serializer2.getDescriptor(), $this$encodePolymorphically$iv.getJson());
            Encoder encoder2 = $this$encodePolymorphically$iv;
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type kotlin.Any");
            SerializationStrategy<T> actualSerializer$iv = PolymorphicSerializerKt.findPolymorphicSerializer(casted$iv, encoder2, value);
            PolymorphicKt.access$validateIfSealed(casted$iv, actualSerializer$iv, baseClassDiscriminator$iv);
            PolymorphicKt.checkKind(actualSerializer$iv.getDescriptor().getKind());
            String it = baseClassDiscriminator$iv;
            boolean bl = false;
            this.polymorphicDiscriminator = it;
            actualSerializer$iv.serialize($this$encodePolymorphically$iv, value);
        }
    }

    private final void encodeTypeInfo(SerialDescriptor descriptor2) {
        this.composer.nextItem();
        String string = this.polymorphicDiscriminator;
        Intrinsics.checkNotNull((Object)string);
        this.encodeString(string);
        this.composer.print(':');
        this.composer.space();
        this.encodeString(descriptor2.getSerialName());
    }

    @Override
    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        WriteMode newMode = WriteModeKt.switchMode(this.getJson(), descriptor2);
        if (newMode.begin != '\u0000') {
            this.composer.print(newMode.begin);
            this.composer.indent();
        }
        if (this.polymorphicDiscriminator != null) {
            this.encodeTypeInfo(descriptor2);
            this.polymorphicDiscriminator = null;
        }
        if (this.mode == newMode) {
            return this;
        }
        Object object = this.modeReuseCache;
        return this.modeReuseCache != null && (object = object[newMode.ordinal()]) != null ? (CompositeEncoder)object : (CompositeEncoder)new StreamingJsonEncoder(this.composer, this.getJson(), newMode, this.modeReuseCache);
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (this.mode.end != '\u0000') {
            this.composer.unIndent();
            this.composer.nextItem();
            this.composer.print(this.mode.end);
        }
    }

    @Override
    public boolean encodeElement(@NotNull SerialDescriptor descriptor2, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                break;
            }
            case 2: {
                if (!this.composer.getWritingFirst()) {
                    boolean bl;
                    if (index % 2 == 0) {
                        this.composer.print(',');
                        this.composer.nextItem();
                        bl = true;
                    } else {
                        this.composer.print(':');
                        this.composer.space();
                        bl = false;
                    }
                    this.forceQuoting = bl;
                    break;
                }
                this.forceQuoting = true;
                this.composer.nextItem();
                break;
            }
            case 3: {
                if (index == 0) {
                    this.forceQuoting = true;
                }
                if (index != 1) break;
                this.composer.print(',');
                this.composer.space();
                this.forceQuoting = false;
                break;
            }
            default: {
                if (!this.composer.getWritingFirst()) {
                    this.composer.print(',');
                }
                this.composer.nextItem();
                this.encodeString(descriptor2.getElementName(index));
                this.composer.print(':');
                this.composer.space();
            }
        }
        return true;
    }

    @Override
    public <T> void encodeNullableSerializableElement(@NotNull SerialDescriptor descriptor2, int index, @NotNull SerializationStrategy<? super T> serializer2, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(serializer2, (String)"serializer");
        if (value != null || this.configuration.getExplicitNulls()) {
            super.encodeNullableSerializableElement(descriptor2, index, serializer2, value);
        }
    }

    @Override
    @NotNull
    public Encoder encodeInline(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return StreamingJsonEncoderKt.isUnsignedNumber(descriptor2) ? (Encoder)new StreamingJsonEncoder(this.composerForUnsignedNumbers(), this.getJson(), this.mode, null) : super.encodeInline(descriptor2);
    }

    private final Composer composerForUnsignedNumbers() {
        return this.composer instanceof ComposerForUnsignedNumbers ? this.composer : (Composer)new ComposerForUnsignedNumbers(this.composer.writer, this.forceQuoting);
    }

    @Override
    public void encodeNull() {
        this.composer.print("null");
    }

    @Override
    public void encodeBoolean(boolean value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeByte(byte value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeShort(short value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeInt(int value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeLong(long value) {
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
    }

    @Override
    public void encodeFloat(float value) {
        float f;
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
        if (!this.configuration.getAllowSpecialFloatingPointValues() && !(!Float.isInfinite(f = value) && !Float.isNaN(f))) {
            throw JsonExceptionsKt.InvalidFloatingPointEncoded(Float.valueOf(value), this.composer.writer.toString());
        }
    }

    @Override
    public void encodeDouble(double value) {
        double d;
        if (this.forceQuoting) {
            this.encodeString(String.valueOf(value));
        } else {
            this.composer.print(value);
        }
        if (!this.configuration.getAllowSpecialFloatingPointValues() && !(!Double.isInfinite(d = value) && !Double.isNaN(d))) {
            throw JsonExceptionsKt.InvalidFloatingPointEncoded(value, this.composer.writer.toString());
        }
    }

    @Override
    public void encodeChar(char value) {
        this.encodeString(String.valueOf(value));
    }

    @Override
    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.composer.printQuoted(value);
    }

    @Override
    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        this.encodeString(enumDescriptor.getElementName(index));
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WriteMode.values().length];
            try {
                nArray[WriteMode.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.MAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.POLY_OBJ.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

