/*
 * Decompiled with CFR 0.152.
 */
package littlechasiu.ctm;

import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.foundation.utility.Couple;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import littlechasiu.ctm.ExtensionsKt;
import littlechasiu.ctm.MathKt;
import littlechasiu.ctm.Track;
import littlechasiu.ctm.model.Edge;
import littlechasiu.ctm.model.Point;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\b\u0018\u0000 12\u00020\u0001:\u00011B/\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0004\b/\u00100J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0006\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\b\u0010\u0007J\u0010\u0010\t\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\u0007J\u0010\u0010\n\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\n\u0010\u0007JB\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u000b\u001a\u00020\u00022\b\b\u0002\u0010\f\u001a\u00020\u00052\b\b\u0002\u0010\r\u001a\u00020\u00052\b\b\u0002\u0010\u000e\u001a\u00020\u00052\b\b\u0002\u0010\u000f\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J#\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u001a\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u001cH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010\u0004R\u0017\u0010\r\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\r\u0010 \u001a\u0004\b!\u0010\u0007R\u0017\u0010\u000e\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010 \u001a\u0004\b\"\u0010\u0007R\u0017\u0010\u000b\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010#\u001a\u0004\b$\u0010\u0004R\u0017\u0010\u000f\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010 \u001a\u0004\b%\u0010\u0007R\u001a\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050&8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0014\u0010-\u001a\u00020*8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0017\u0010\f\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\f\u0010 \u001a\u0004\b.\u0010\u0007\u00a8\u00062"}, d2={"Llittlechasiu/ctm/BezierCurve;", "Llittlechasiu/ctm/Track;", "", "component1", "()Ljava/lang/String;", "Lnet/minecraft/class_243;", "component2", "()Lnet/minecraft/class_243;", "component3", "component4", "component5", "dimension", "start", "controlPoint1", "controlPoint2", "end", "copy", "(Ljava/lang/String;Lnet/minecraft/class_243;Lnet/minecraft/class_243;Lnet/minecraft/class_243;Lnet/minecraft/class_243;)Llittlechasiu/ctm/BezierCurve;", "", "position", "Lkotlin/Pair;", "divideAt", "(D)Lkotlin/Pair;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Lnet/minecraft/class_243;", "getControlPoint1", "getControlPoint2", "Ljava/lang/String;", "getDimension", "getEnd", "", "getPoints", "()Ljava/util/List;", "points", "Llittlechasiu/ctm/model/Edge;", "getSendable", "()Llittlechasiu/ctm/model/Edge;", "sendable", "getStart", "<init>", "(Ljava/lang/String;Lnet/minecraft/class_243;Lnet/minecraft/class_243;Lnet/minecraft/class_243;Lnet/minecraft/class_243;)V", "Companion", "create-track-map"})
public final class BezierCurve
implements Track {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String dimension;
    @NotNull
    private final class_243 start;
    @NotNull
    private final class_243 controlPoint1;
    @NotNull
    private final class_243 controlPoint2;
    @NotNull
    private final class_243 end;

    public BezierCurve(@NotNull String dimension, @NotNull class_243 start2, @NotNull class_243 controlPoint1, @NotNull class_243 controlPoint2, @NotNull class_243 end2) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)controlPoint1, (String)"controlPoint1");
        Intrinsics.checkNotNullParameter((Object)controlPoint2, (String)"controlPoint2");
        Intrinsics.checkNotNullParameter((Object)end2, (String)"end");
        this.dimension = dimension;
        this.start = start2;
        this.controlPoint1 = controlPoint1;
        this.controlPoint2 = controlPoint2;
        this.end = end2;
    }

    @NotNull
    public final String getDimension() {
        return this.dimension;
    }

    @NotNull
    public final class_243 getStart() {
        return this.start;
    }

    @NotNull
    public final class_243 getControlPoint1() {
        return this.controlPoint1;
    }

    @NotNull
    public final class_243 getControlPoint2() {
        return this.controlPoint2;
    }

    @NotNull
    public final class_243 getEnd() {
        return this.end;
    }

    @Override
    @NotNull
    public Edge getSendable() {
        Object[] objectArray = new Point[]{ExtensionsKt.getSendable(this.start), ExtensionsKt.getSendable(this.controlPoint1), ExtensionsKt.getSendable(this.controlPoint2), ExtensionsKt.getSendable(this.end)};
        return new Edge(this.dimension, CollectionsKt.listOf((Object[])objectArray));
    }

    private final List<class_243> getPoints() {
        Object[] objectArray = new class_243[]{this.start, this.controlPoint1, this.controlPoint2, this.end};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public Pair<BezierCurve, BezierCurve> divideAt(double position) {
        List<class_243> points1 = MathKt.multiLerp(this.getPoints(), position);
        List<class_243> points2 = MathKt.multiLerp(points1, position);
        List<class_243> points3 = MathKt.multiLerp(points2, position);
        class_243 cp11 = points1.get(0);
        class_243 cp12 = points2.get(0);
        class_243 midpoint = points3.get(0);
        class_243 cp21 = points2.get(1);
        class_243 cp22 = points1.get(2);
        return new Pair((Object)new BezierCurve(this.dimension, this.start, cp11, cp12, midpoint), (Object)new BezierCurve(this.dimension, midpoint, cp21, cp22, this.end));
    }

    @NotNull
    public final String component1() {
        return this.dimension;
    }

    @NotNull
    public final class_243 component2() {
        return this.start;
    }

    @NotNull
    public final class_243 component3() {
        return this.controlPoint1;
    }

    @NotNull
    public final class_243 component4() {
        return this.controlPoint2;
    }

    @NotNull
    public final class_243 component5() {
        return this.end;
    }

    @NotNull
    public final BezierCurve copy(@NotNull String dimension, @NotNull class_243 start2, @NotNull class_243 controlPoint1, @NotNull class_243 controlPoint2, @NotNull class_243 end2) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"dimension");
        Intrinsics.checkNotNullParameter((Object)start2, (String)"start");
        Intrinsics.checkNotNullParameter((Object)controlPoint1, (String)"controlPoint1");
        Intrinsics.checkNotNullParameter((Object)controlPoint2, (String)"controlPoint2");
        Intrinsics.checkNotNullParameter((Object)end2, (String)"end");
        return new BezierCurve(dimension, start2, controlPoint1, controlPoint2, end2);
    }

    public static /* synthetic */ BezierCurve copy$default(BezierCurve bezierCurve, String string, class_243 class_2432, class_243 class_2433, class_243 class_2434, class_243 class_2435, int n, Object object) {
        if ((n & 1) != 0) {
            string = bezierCurve.dimension;
        }
        if ((n & 2) != 0) {
            class_2432 = bezierCurve.start;
        }
        if ((n & 4) != 0) {
            class_2433 = bezierCurve.controlPoint1;
        }
        if ((n & 8) != 0) {
            class_2434 = bezierCurve.controlPoint2;
        }
        if ((n & 0x10) != 0) {
            class_2435 = bezierCurve.end;
        }
        return bezierCurve.copy(string, class_2432, class_2433, class_2434, class_2435);
    }

    @NotNull
    public String toString() {
        return "BezierCurve(dimension=" + this.dimension + ", start=" + this.start + ", controlPoint1=" + this.controlPoint1 + ", controlPoint2=" + this.controlPoint2 + ", end=" + this.end + ")";
    }

    public int hashCode() {
        int result2 = this.dimension.hashCode();
        result2 = result2 * 31 + this.start.hashCode();
        result2 = result2 * 31 + this.controlPoint1.hashCode();
        result2 = result2 * 31 + this.controlPoint2.hashCode();
        result2 = result2 * 31 + this.end.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BezierCurve)) {
            return false;
        }
        BezierCurve bezierCurve = (BezierCurve)other;
        if (!Intrinsics.areEqual((Object)this.dimension, (Object)bezierCurve.dimension)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.start, (Object)bezierCurve.start)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.controlPoint1, (Object)bezierCurve.controlPoint1)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.controlPoint2, (Object)bezierCurve.controlPoint2)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.end, (Object)bezierCurve.end);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Llittlechasiu/ctm/BezierCurve$Companion;", "", "Lcom/simibubi/create/content/trains/track/BezierConnection;", "conn", "", "dim", "Llittlechasiu/ctm/BezierCurve;", "from", "(Lcom/simibubi/create/content/trains/track/BezierConnection;Ljava/lang/String;)Llittlechasiu/ctm/BezierCurve;", "<init>", "()V", "create-track-map"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BezierCurve from(@NotNull BezierConnection conn, @NotNull String dim) {
            Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
            Intrinsics.checkNotNullParameter((Object)dim, (String)"dim");
            Couple couple = conn.starts;
            Intrinsics.checkNotNullExpressionValue((Object)couple, (String)"starts");
            class_243 start2 = (class_243)ExtensionsKt.component1(couple);
            class_243 end2 = (class_243)ExtensionsKt.component2(couple);
            Couple couple2 = conn.axes;
            Intrinsics.checkNotNullExpressionValue((Object)couple2, (String)"axes");
            class_243 startAxis = (class_243)ExtensionsKt.component1(couple2);
            class_243 endAxis = (class_243)ExtensionsKt.component2(couple2);
            Intrinsics.checkNotNullExpressionValue((Object)start2, (String)"start");
            Intrinsics.checkNotNullExpressionValue((Object)startAxis, (String)"startAxis");
            class_243 class_2432 = MathKt.plus(start2, MathKt.times(startAxis, conn.getHandleLength()));
            Intrinsics.checkNotNullExpressionValue((Object)end2, (String)"end");
            Intrinsics.checkNotNullExpressionValue((Object)endAxis, (String)"endAxis");
            return new BezierCurve(dim, start2, class_2432, MathKt.plus(end2, MathKt.times(endAxis, conn.getHandleLength())), end2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

