/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.data.storage;

import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.camera.capture.CapturedFramesHistory;
import io.github.mortuusars.exposure.data.storage.ExposureSavedData;
import io.github.mortuusars.exposure.data.storage.IServersideExposureStorage;
import io.github.mortuusars.exposure.network.Packets;
import io.github.mortuusars.exposure.network.packet.client.ExposureChangedS2CP;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_26;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ServersideExposureStorage
implements IServersideExposureStorage {
    private static final String EXPOSURE_DIR = "exposures";
    private final MinecraftServer server;
    private final Supplier<class_26> levelStorageSupplier;
    private final Supplier<Path> worldPathSupplier;

    public ServersideExposureStorage(MinecraftServer server) {
        this.server = server;
        this.levelStorageSupplier = () -> server.method_30002().method_17983();
        this.worldPathSupplier = () -> server.method_27050(class_5218.field_24188);
    }

    @Override
    public Optional<ExposureSavedData> getOrQuery(String id) {
        class_26 dataStorage = this.levelStorageSupplier.get();
        @Nullable ExposureSavedData loadedExposureData = (ExposureSavedData)dataStorage.method_20786(ExposureSavedData::load, this.getSaveId(id));
        if (loadedExposureData == null) {
            Exposure.LOGGER.error("Exposure '{}' was not loaded. File does not exist or some error occurred.", (Object)id);
        }
        return Optional.ofNullable(loadedExposureData);
    }

    @Override
    public void put(String id, ExposureSavedData data) {
        if (this.createStorageDirectory()) {
            class_26 dataStorage = this.levelStorageSupplier.get();
            dataStorage.method_123(this.getSaveId(id), (class_18)data);
            data.method_80();
            if (this.server.method_3816()) {
                class_2487 frameTag = new class_2487();
                frameTag.method_10582("Id", id);
                CapturedFramesHistory.add(frameTag);
            }
        }
    }

    @Override
    public List<String> getAllIds() {
        this.levelStorageSupplier.get().method_125();
        Path path = this.worldPathSupplier.get().resolve("data/exposures");
        File folder = path.toFile();
        @Nullable File[] listOfFiles = folder.listFiles();
        if (listOfFiles == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (File file : listOfFiles) {
            if (file == null || !file.isFile()) continue;
            ids.add(com.google.common.io.Files.getNameWithoutExtension((String)file.getName()));
        }
        return ids;
    }

    @Override
    public void clear() {
        Exposure.LOGGER.warn("Clearing Server Exposure Storage is not implemented.");
    }

    @Override
    public void sendExposureChanged(String exposureId) {
        Packets.sendToAllClients(new ExposureChangedS2CP(exposureId));
    }

    private String getSaveId(String id) {
        return "exposures/" + id;
    }

    private boolean createStorageDirectory() {
        try {
            Path path = this.worldPathSupplier.get().resolve("data/exposures");
            return Files.exists(path, new LinkOption[0]) || path.toFile().mkdirs();
        }
        catch (Exception e) {
            Exposure.LOGGER.error("Failed to create exposure storage directory: {}", (Object)e.toString());
            return false;
        }
    }
}

