/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.change;

import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.IChiselsAndBitsAPI;
import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.change.changes.IChange;
import mod.chiselsandbits.api.change.changes.IllegalChangeAttempt;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.INBTSerializable;
import mod.chiselsandbits.change.ChangeTrackerSyncManager;
import mod.chiselsandbits.change.changes.BitChange;
import mod.chiselsandbits.change.changes.CombinedChange;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;

public class ChangeTracker
implements IChangeTracker {
    protected final class_1657 player;
    protected final LinkedList<CombinedChange> changes = new LinkedList();
    protected int currentIndex = 0;

    public ChangeTracker() {
        this.player = null;
    }

    public ChangeTracker(class_1657 player) {
        this.player = player;
    }

    public void reset() {
        this.changes.clear();
        this.sendUpdate();
    }

    @Override
    public void onBlocksUpdated(Map<class_2338, IMultiStateSnapshot> beforeStates, Map<class_2338, IMultiStateSnapshot> afterState) {
        if (!beforeStates.keySet().containsAll(afterState.keySet()) || !afterState.keySet().containsAll(beforeStates.keySet())) {
            throw new IllegalArgumentException("Initial States and Target States reference difference block positions");
        }
        this.changes.addFirst(new CombinedChange(beforeStates.entrySet().stream().map(e -> new BitChange((class_2338)e.getKey(), (IMultiStateSnapshot)e.getValue(), (IMultiStateSnapshot)afterState.get(e.getKey()))).collect(Collectors.toSet())));
        this.currentIndex = 0;
        int maxSize = IChiselsAndBitsAPI.getInstance().getConfiguration().getServer().getChangeTrackerSize().get();
        if (this.changes.size() > maxSize) {
            while (this.changes.size() > maxSize) {
                this.changes.removeLast();
            }
        }
        this.sendUpdate();
    }

    @Override
    public Deque<IChange> getChanges() {
        return new LinkedList<IChange>(this.changes);
    }

    @Override
    public void clear() {
        this.changes.clear();
        this.sendUpdate();
    }

    public Optional<IChange> getCurrentUndo() {
        if (this.getChanges().size() <= this.currentIndex || this.currentIndex < 0) {
            return Optional.empty();
        }
        return Optional.of((IChange)this.changes.get(this.currentIndex));
    }

    public Optional<IChange> getCurrentRedo() {
        if (this.getChanges().size() < this.currentIndex || this.currentIndex < 1) {
            return Optional.empty();
        }
        return Optional.of((IChange)this.changes.get(this.currentIndex - 1));
    }

    @Override
    public boolean canUndo(class_1657 player) {
        return this.getCurrentUndo().map(c -> c.canUndo(player)).orElse(false);
    }

    @Override
    public boolean canRedo(class_1657 player) {
        return this.getCurrentRedo().map(c -> c.canRedo(player)).orElse(false);
    }

    @Override
    public void undo(class_1657 player) throws IllegalChangeAttempt {
        if (!this.canUndo(player)) {
            throw new IllegalChangeAttempt();
        }
        if (this.getCurrentUndo().isPresent()) {
            IChange change = this.getCurrentUndo().get();
            change.undo(player);
            this.currentIndex = Math.min(this.changes.size(), this.currentIndex + 1);
            this.sendUpdate();
        }
    }

    @Override
    public void redo(class_1657 player) throws IllegalChangeAttempt {
        if (!this.canRedo(player)) {
            throw new IllegalChangeAttempt();
        }
        if (this.getCurrentRedo().isPresent()) {
            IChange change = this.getCurrentRedo().get();
            change.redo(player);
            this.currentIndex = Math.max(0, this.currentIndex - 1);
            this.sendUpdate();
        }
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        tag.method_10566("changes", (class_2520)this.changes.stream().map(INBTSerializable::serializeNBT).collect(Collectors.toCollection(class_2499::new)));
        tag.method_10569("index", this.currentIndex);
        return tag;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        this.changes.clear();
        this.changes.addAll(nbt.method_10554("changes", 10).stream().map(CombinedChange::new).toList());
        this.currentIndex = nbt.method_10550("index");
    }

    private void sendUpdate() {
        class_3222 serverPlayer;
        class_1657 class_16572;
        if (this.player != null && (class_16572 = this.player) instanceof class_3222 && !(serverPlayer = (class_3222)class_16572).method_37908().method_8608()) {
            ChangeTrackerSyncManager.getInstance().add(this, serverPlayer);
        }
    }
}

