/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.multistate.mutator;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.blockinformation.IBlockInformation;
import mod.chiselsandbits.api.change.IChangeTracker;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessorWithVoxelShape;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.world.IInWorldMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.BlockPosForEach;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.IBatchMutation;
import mod.chiselsandbits.api.util.VectorUtils;
import mod.chiselsandbits.api.voxelshape.IVoxelShapeManager;
import mod.chiselsandbits.multistate.mutator.ChiselAdaptingWorldMutator;
import mod.chiselsandbits.multistate.snapshot.MultiBlockMultiStateSnapshot;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_259;
import net.minecraft.class_265;
import org.jetbrains.annotations.NotNull;

public class WorldWrappingMutator
implements IWorldAreaMutator,
IAreaAccessorWithVoxelShape {
    private final class_1936 world;
    private final class_243 startPoint;
    private final class_243 endPoint;

    public WorldWrappingMutator(class_1936 world, class_243 startPoint, class_243 endPoint) {
        this.world = world;
        this.startPoint = new class_243(Math.min(startPoint.method_10216(), endPoint.method_10216()), Math.min(startPoint.method_10214(), endPoint.method_10214()), Math.min(startPoint.method_10215(), endPoint.method_10215()));
        this.endPoint = new class_243(Math.max(startPoint.method_10216(), endPoint.method_10216()), Math.max(startPoint.method_10214(), endPoint.method_10214()), Math.max(startPoint.method_10215(), endPoint.method_10215()));
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        class_2338 endBlockPos;
        class_2338 startBlockPos = this.getInWorldStartBlockPoint();
        Stream<class_2338> positionStream = startBlockPos.equals((Object)(endBlockPos = this.getInWorldEndBlockPoint())) ? Stream.of(startBlockPos) : BlockPosStreamProvider.getForRange(startBlockPos.method_10263(), startBlockPos.method_10264(), startBlockPos.method_10260(), endBlockPos.method_10263(), endBlockPos.method_10264(), endBlockPos.method_10260());
        Collection identifiers = positionStream.map(blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (class_2338)blockPos)).map(ChiselAdaptingWorldMutator::createNewShapeIdentifier).collect(Collectors.toList());
        return new Identifier(identifiers, this.startPoint, this.endPoint);
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        return this.inWorldMutableStream().map(IStateEntryInfo.class::cast);
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(class_243 inAreaTarget) {
        if (!this.isInside(inAreaTarget)) {
            return Optional.empty();
        }
        class_2338 exactPosition = VectorUtils.toBlockPos(inAreaTarget);
        class_243 exactInBlockOffset = inAreaTarget.method_1023((double)exactPosition.method_10263(), (double)exactPosition.method_10264(), (double)exactPosition.method_10260());
        return this.getInBlockTarget(exactPosition, exactInBlockOffset);
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        if (!this.isInside(inAreaBlockPosOffset, inBlockTarget)) {
            return Optional.empty();
        }
        return new ChiselAdaptingWorldMutator(this.getWorld(), inAreaBlockPosOffset).getInAreaTarget(inBlockTarget);
    }

    @Override
    public boolean isInside(class_243 inAreaTarget) {
        return this.getInWorldBoundingBox().method_1006(inAreaTarget);
    }

    @Override
    public boolean isInside(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        return this.isInside(class_243.method_24954((class_2382)inAreaBlockPosOffset).method_1019(inBlockTarget));
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        class_2338 endBlockPos;
        class_2338 startBlockPos = this.getInWorldStartBlockPoint();
        Stream<class_2338> positionStream = startBlockPos.equals((Object)(endBlockPos = this.getInWorldEndBlockPoint())) ? Stream.of(startBlockPos) : BlockPosStreamProvider.getForRange(startBlockPos.method_10263(), startBlockPos.method_10264(), startBlockPos.method_10260(), endBlockPos.method_10263(), endBlockPos.method_10264(), endBlockPos.method_10260());
        Map<class_2338, IMultiStateSnapshot> snapshots = positionStream.collect(Collectors.toMap(Function.identity(), blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (class_2338)blockPos).createSnapshot()));
        return new MultiBlockMultiStateSnapshot(snapshots, this.getInWorldStartPoint(), this.getInWorldEndPoint());
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        return BlockPosStreamProvider.getForRange(this.getInWorldStartPoint().method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()), this.getInWorldEndPoint().method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide())).map(positionMutator::mutate).map(position -> class_243.method_24954((class_2382)position).method_18805((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())).map(position -> {
            class_2338 blockPos = VectorUtils.toBlockPos(position);
            class_243 inBlockOffset = position.method_1020(class_243.method_24954((class_2382)blockPos));
            return this.getInBlockTarget(blockPos, inBlockOffset);
        }).filter(Optional::isPresent).map(Optional::get);
    }

    @Override
    public void forEachWithPositionMutator(IPositionMutator positionMutator, Consumer<IStateEntryInfo> consumer) {
        BlockPosForEach.forEachInRange(this.getInWorldStartPoint().method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()), this.getInWorldEndPoint().method_18805((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()), blockPos -> {
            class_2382 target = positionMutator.mutate((class_2382)blockPos);
            class_243 scaledTarget = class_243.method_24954((class_2382)target).method_18806(StateEntrySize.current().getSizePerBitScalingVector());
            class_2338 position = new class_2338((class_2382)blockPos);
            class_243 inBlockOffset = scaledTarget.method_1020(class_243.method_24954((class_2382)position));
            Optional<IStateEntryInfo> targetCandidate = this.getInBlockTarget(position, inBlockOffset);
            targetCandidate.ifPresent(consumer);
        });
    }

    @Override
    public class_1936 getWorld() {
        return this.world;
    }

    @Override
    public class_243 getInWorldStartPoint() {
        return this.startPoint;
    }

    @Override
    public class_243 getInWorldEndPoint() {
        return this.endPoint;
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        return this.inWorldMutableStream().map(IMutableStateEntryInfo.class::cast);
    }

    @Override
    public void setInAreaTarget(IBlockInformation blockInformation, class_243 inAreaTarget) throws SpaceOccupiedException {
        if (inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0) {
            throw new IllegalArgumentException(String.format("The in area target can not have a negative component: %s", inAreaTarget));
        }
        class_243 actualTarget = this.getInWorldStartPoint().method_1019(inAreaTarget);
        if (actualTarget.method_10216() >= this.getInWorldEndPoint().method_10216() || actualTarget.method_10214() >= this.getInWorldEndPoint().method_10214() || actualTarget.method_10215() >= this.getInWorldEndPoint().method_10215()) {
            throw new IllegalArgumentException(String.format("The in area target is larger then the allowed size:%s", inAreaTarget));
        }
        class_2338 blockPosTarget = VectorUtils.toBlockPos(actualTarget);
        class_243 inBlockPosTarget = actualTarget.method_1020(class_243.method_24954((class_2382)blockPosTarget));
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), blockPosTarget);
        innerMutator.setInAreaTarget(blockInformation, inBlockPosTarget);
    }

    @Override
    public void setInBlockTarget(IBlockInformation blockInformation, class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) throws SpaceOccupiedException {
        class_2338 startPos = this.getInWorldStartBlockPoint();
        class_2338 targetPos = startPos.method_10081((class_2382)inAreaBlockPosOffset);
        class_243 target = class_243.method_24954((class_2382)targetPos).method_1019(inBlockTarget);
        if (target.method_10216() < this.getInWorldStartPoint().method_10216() || target.method_10214() < this.getInWorldStartPoint().method_10214() || target.method_10215() < this.getInWorldStartPoint().method_10215()) {
            throw new IllegalArgumentException(String.format("The target can not be smaller then the start point: %s", target));
        }
        if (target.method_10216() >= this.getInWorldEndPoint().method_10216() || target.method_10214() >= this.getInWorldEndPoint().method_10214() || target.method_10215() >= this.getInWorldEndPoint().method_10215()) {
            throw new IllegalArgumentException(String.format("The target can not be greater then the start point: %s", target));
        }
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), targetPos);
        innerMutator.setInBlockTarget(blockInformation, class_2338.field_10980, inBlockTarget);
    }

    @Override
    public void clearInAreaTarget(class_243 inAreaTarget) {
        if (inAreaTarget.method_10216() < 0.0 || inAreaTarget.method_10214() < 0.0 || inAreaTarget.method_10215() < 0.0) {
            throw new IllegalArgumentException(String.format("The in area target can not have a negative component: %s", inAreaTarget));
        }
        class_243 actualTarget = this.getInWorldStartPoint().method_1019(inAreaTarget);
        if (actualTarget.method_10216() >= this.getInWorldEndPoint().method_10216() || actualTarget.method_10214() >= this.getInWorldEndPoint().method_10214() || actualTarget.method_10215() >= this.getInWorldEndPoint().method_10215()) {
            throw new IllegalArgumentException(String.format("The in area target is larger then the allowed size:%s", inAreaTarget));
        }
        class_2338 blockPosTarget = VectorUtils.toBlockPos(actualTarget);
        class_243 inBlockPosTarget = actualTarget.method_1020(class_243.method_24954((class_2382)blockPosTarget));
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), blockPosTarget);
        innerMutator.clearInAreaTarget(inBlockPosTarget);
    }

    @Override
    public void clearInBlockTarget(class_2338 inAreaBlockPosOffset, class_243 inBlockTarget) {
        class_2338 startPos = this.getInWorldStartBlockPoint();
        class_2338 targetPos = startPos.method_10081((class_2382)inAreaBlockPosOffset);
        class_243 target = class_243.method_24954((class_2382)targetPos).method_1019(inBlockTarget);
        if (target.method_10216() < this.getInWorldStartPoint().method_10216() || target.method_10214() < this.getInWorldStartPoint().method_10214() || target.method_10215() < this.getInWorldStartPoint().method_10215()) {
            throw new IllegalArgumentException(String.format("The target can not be smaller then the start point: %s", target));
        }
        if (target.method_10216() >= this.getInWorldEndPoint().method_10216() || target.method_10214() >= this.getInWorldEndPoint().method_10214() || target.method_10215() >= this.getInWorldEndPoint().method_10215()) {
            throw new IllegalArgumentException(String.format("The target can not be greater then the start point: %s", target));
        }
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), targetPos);
        innerMutator.clearInBlockTarget(class_2338.field_10980, inBlockTarget);
    }

    @Override
    public Stream<IInWorldMutableStateEntryInfo> inWorldMutableStream() {
        return BlockPosStreamProvider.getForRange(this.getInWorldStartPoint(), this.getInWorldEndPoint()).flatMap(blockPos -> this.positionBasedInWorldMutableStream((class_2338)blockPos).filter(entry -> this.getInWorldBoundingBox().method_994(entry.getInWorldBoundingBox()) || entry.getInWorldBoundingBox().method_994(this.getInWorldBoundingBox())));
    }

    private Stream<IInWorldMutableStateEntryInfo> positionBasedInWorldMutableStream(class_2338 position) {
        ChiselAdaptingWorldMutator innerMutator = new ChiselAdaptingWorldMutator(this.getWorld(), position);
        return innerMutator.inWorldMutableStream();
    }

    @Override
    public IBatchMutation batch() {
        return new BatchMutationLock(BlockPosStreamProvider.getForRange(this.getInWorldStartPoint(), this.getInWorldEndPoint()).map(blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (class_2338)blockPos)).map(ChiselAdaptingWorldMutator::batch).collect(Collectors.toList()));
    }

    @Override
    public IBatchMutation batch(IChangeTracker changeTracker) {
        Map<class_2338, IMultiStateSnapshot> before = BlockPosStreamProvider.getForRange(this.getInWorldStartPoint(), this.getInWorldEndPoint()).map(blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (class_2338)blockPos)).collect(Collectors.toMap(ChiselAdaptingWorldMutator::getPos, ChiselAdaptingWorldMutator::createSnapshot));
        IBatchMutation innerMutation = this.batch();
        return () -> {
            Map<class_2338, IMultiStateSnapshot> after = BlockPosStreamProvider.getForRange(this.getInWorldStartPoint(), this.getInWorldEndPoint()).map(blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (class_2338)blockPos)).collect(Collectors.toMap(ChiselAdaptingWorldMutator::getPos, ChiselAdaptingWorldMutator::createSnapshot));
            innerMutation.close();
            changeTracker.onBlocksUpdated(before, after);
        };
    }

    @Override
    public class_265 provideShape(CollisionType type, class_2338 offset, boolean simplify) {
        class_265 areaShape = class_259.method_1078((class_238)this.getInWorldBoundingBox().method_996(VectorUtils.invert(this.getInWorldStartBlockPoint())).method_996(offset));
        class_265 containedShape = BlockPosStreamProvider.getForRange(this.getInWorldStartPoint(), this.getInWorldEndPoint()).map(blockPos -> new ChiselAdaptingWorldMutator(this.getWorld(), (class_2338)blockPos)).map(a -> IVoxelShapeManager.getInstance().get((IAreaAccessor)a, a.getInWorldStartBlockPoint().method_10081((class_2382)VectorUtils.invert(this.getInWorldStartBlockPoint())).method_10081((class_2382)offset), type, simplify)).reduce(class_259.method_1073(), (voxelShape, bbShape) -> class_259.method_1082((class_265)voxelShape, (class_265)bbShape, (class_247)class_247.field_1366), (voxelShape, voxelShape2) -> class_259.method_1082((class_265)voxelShape, (class_265)voxelShape2, (class_247)class_247.field_1366));
        class_265 requestedShape = class_259.method_1082((class_265)areaShape, (class_265)containedShape, (class_247)class_247.field_16896);
        return simplify ? requestedShape.method_1097() : requestedShape;
    }

    public String toString() {
        return "WorldWrappingMutator{world=" + this.world + ", startPoint=" + this.startPoint + ", endPoint=" + this.endPoint + "}";
    }

    @Override
    @NotNull
    public class_238 getBoundingBox() {
        return new class_238(this.startPoint, this.endPoint);
    }

    private static final class Identifier
    implements IAreaShapeIdentifier {
        private final Collection<IAreaShapeIdentifier> inners;
        private final class_243 startPoint;
        private final class_243 endPoint;

        public Identifier(Collection<IAreaShapeIdentifier> innerSnapshots, class_243 startPoint, class_243 endPoint) {
            this.inners = innerSnapshots;
            this.startPoint = startPoint;
            this.endPoint = endPoint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Identifier)) {
                return false;
            }
            Identifier that = (Identifier)o;
            return this.inners.equals(that.inners) && this.startPoint.equals((Object)that.startPoint) && this.endPoint.equals((Object)that.endPoint);
        }

        public int hashCode() {
            return Objects.hash(this.inners, this.startPoint, this.endPoint);
        }
    }

    private static final class BatchMutationLock
    implements IBatchMutation {
        private final Iterable<IBatchMutation> innerLocks;

        private BatchMutationLock(Iterable<IBatchMutation> innerLocks) {
            this.innerLocks = innerLocks;
        }

        @Override
        public void close() {
            for (IBatchMutation innerLock : this.innerLocks) {
                innerLock.close();
            }
        }
    }
}

