/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.profiling;

import java.util.function.Consumer;
import mod.chiselsandbits.api.profiling.IProfiler;
import mod.chiselsandbits.api.profiling.IProfilerResult;
import mod.chiselsandbits.api.profiling.IProfilerSection;
import mod.chiselsandbits.api.profiling.IProfilingManager;
import mod.chiselsandbits.profiling.CandBProfiler;
import mod.chiselsandbits.profiling.jvm.jfr.JfrCandBProfiler;
import net.minecraft.class_6506;
import net.minecraft.class_6611;

public class ProfilingManager
implements IProfilingManager {
    private static final ProfilingManager INSTANCE = new ProfilingManager();
    public IProfiler profiler = null;

    public static ProfilingManager getInstance() {
        return INSTANCE;
    }

    private ProfilingManager() {
    }

    @Override
    public IProfiler startProfiling(class_6506 profilingEnvironment) {
        if (class_6611.field_34923.method_38658()) {
            return new JfrCandBProfiler(profilingEnvironment);
        }
        return new CandBProfiler();
    }

    @Override
    public IProfilerResult endProfiling(IProfiler profiler) {
        if (!(profiler instanceof CandBProfiler)) {
            throw new IllegalArgumentException("Profiler is not a Chisels and Bits Profiler");
        }
        CandBProfiler candBProfiler = (CandBProfiler)profiler;
        return candBProfiler.getResult();
    }

    @Override
    public IProfilerResult stopProfiling(IProfiler profiler) {
        if (!(profiler instanceof CandBProfiler)) {
            throw new IllegalArgumentException("Profiler is not a Chisels and Bits Profiler");
        }
        CandBProfiler candBProfiler = (CandBProfiler)profiler;
        this.profiler = null;
        return candBProfiler.stop();
    }

    public IProfiler getProfiler() {
        return this.profiler;
    }

    public void setProfiler(IProfiler profiler) {
        this.profiler = profiler;
    }

    public boolean hasProfiler() {
        return this.getProfiler() != null;
    }

    public void withProfiler(Consumer<IProfiler> callback) {
        if (this.hasProfiler()) {
            callback.accept(this.getProfiler());
        }
    }

    public IProfilerSection withSection(String name) {
        IProfiler profiler = this.getProfiler();
        if (profiler != null) {
            profiler.startSection(name);
        }
        return () -> {
            if (profiler != null) {
                profiler.endSection();
            }
        };
    }
}

