/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import com.communi.suggestu.scena.core.registries.IPlatformRegistryManager;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StringStateUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    private StringStateUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: StringStateUtils. This is a utility class");
    }

    public static int getStateIDFromName(String name) {
        String[] parts = name.split("[?&]");
        parts[0] = URLDecoder.decode(parts[0], StandardCharsets.UTF_8);
        Optional blk = IPlatformRegistryManager.getInstance().getBlockRegistry().getValue(new class_2960(parts[0]));
        if (blk.isEmpty() || blk.get() instanceof class_2189) {
            return 0;
        }
        class_2680 state = ((class_2248)blk.get()).method_9564();
        for (int x = 1; x < parts.length; ++x) {
            try {
                String[] nameValues;
                if (parts[x].length() <= 0 || (nameValues = parts[x].split("[=]")).length != 2) continue;
                nameValues[0] = URLDecoder.decode(nameValues[0], StandardCharsets.UTF_8);
                nameValues[1] = URLDecoder.decode(nameValues[1], StandardCharsets.UTF_8);
                state = StringStateUtils.withState(state, (class_2248)blk.get(), nameValues);
                continue;
            }
            catch (Exception err) {
                LOGGER.error("Failed to reload Property from store data : " + name, (Throwable)err);
            }
        }
        return IBlockStateIdManager.getInstance().getIdFrom(state);
    }

    private static class_2680 withState(class_2680 state, class_2248 blk, String[] nameval) {
        class_2769 prop = blk.method_9595().method_11663(nameval[0]);
        if (prop == null) {
            LOGGER.info(nameval[0] + " is not a valid property for " + IPlatformRegistryManager.getInstance().getBlockRegistry().getKey((Object)blk));
            return state;
        }
        return StringStateUtils.setPropValue(state, prop, nameval[1]);
    }

    public static <T extends Comparable<T>> class_2680 setPropValue(class_2680 blockState, class_2769<T> property, String value) {
        Optional pv = property.method_11900(value);
        if (pv.isPresent()) {
            return (class_2680)blockState.method_11657(property, (Comparable)pv.get());
        }
        LOGGER.info(value + " is not a valid value of " + property.method_11899() + " for " + IPlatformRegistryManager.getInstance().getBlockRegistry().getKey((Object)blockState.method_26204()));
        return blockState;
    }

    public static String getNameFromStateID(int key) {
        class_2680 state = IBlockStateIdManager.getInstance().getBlockStateFrom(key);
        class_2248 blk = state.method_26204();
        String sname = "air?";
        StringBuilder stateName = new StringBuilder(URLEncoder.encode(Objects.requireNonNull(IPlatformRegistryManager.getInstance().getBlockRegistry().getKey((Object)blk)).toString(), StandardCharsets.UTF_8));
        stateName.append('?');
        boolean first = true;
        for (class_2769 p : state.method_26204().method_9595().method_11659()) {
            if (!first) {
                stateName.append('&');
            }
            first = false;
            Comparable propVal = state.method_11654(p);
            String saveAs = propVal instanceof class_3542 ? ((class_3542)propVal).method_15434() : propVal.toString();
            stateName.append(URLEncoder.encode(p.method_11899(), StandardCharsets.UTF_8));
            stateName.append('=');
            stateName.append(URLEncoder.encode(saveAs, StandardCharsets.UTF_8));
        }
        sname = stateName.toString();
        return sname;
    }
}

