/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.networking.fabric;

import com.mojang.logging.LogUtils;
import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.fabric.SpawnEntityPacket;
import dev.architectury.networking.transformers.PacketSink;
import dev.architectury.networking.transformers.PacketTransformer;
import dev.architectury.utils.Env;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1255;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_634;
import org.slf4j.Logger;

public class NetworkManagerImpl {
    private static final Map<class_2960, NetworkManager.NetworkReceiver> C2S_RECEIVER = new HashMap<class_2960, NetworkManager.NetworkReceiver>();
    private static final Map<class_2960, NetworkManager.NetworkReceiver> S2C_RECEIVER = new HashMap<class_2960, NetworkManager.NetworkReceiver>();
    private static final Map<class_2960, PacketTransformer> C2S_TRANSFORMERS = new HashMap<class_2960, PacketTransformer>();
    private static final Map<class_2960, PacketTransformer> S2C_TRANSFORMERS = new HashMap<class_2960, PacketTransformer>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void registerReceiver(NetworkManager.Side side, class_2960 id, List<PacketTransformer> packetTransformers, NetworkManager.NetworkReceiver receiver) {
        Objects.requireNonNull(id, "Cannot register receiver with a null ID!");
        packetTransformers = Objects.requireNonNullElse(packetTransformers, List.of());
        Objects.requireNonNull(receiver, "Cannot register a null receiver!");
        if (side == NetworkManager.Side.C2S) {
            NetworkManagerImpl.registerC2SReceiver(id, packetTransformers, receiver);
        } else if (side == NetworkManager.Side.S2C) {
            NetworkManagerImpl.registerS2CReceiver(id, packetTransformers, receiver);
        }
    }

    private static void registerC2SReceiver(class_2960 id, List<PacketTransformer> packetTransformers, NetworkManager.NetworkReceiver receiver) {
        LOGGER.info("Registering C2S receiver with id {}", (Object)id);
        C2S_RECEIVER.put(id, receiver);
        PacketTransformer transformer = PacketTransformer.concat(packetTransformers);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)id, (server, player, handler, buf, sender) -> {
            NetworkManager.PacketContext context = NetworkManagerImpl.context((class_1657)player, server, false);
            transformer.inbound(NetworkManager.Side.C2S, id, buf, context, (side, id1, buf1) -> {
                NetworkManager.NetworkReceiver networkReceiver;
                NetworkManager.NetworkReceiver networkReceiver2 = networkReceiver = side == NetworkManager.Side.C2S ? C2S_RECEIVER.get(id1) : S2C_RECEIVER.get(id1);
                if (networkReceiver == null) {
                    throw new IllegalArgumentException("Network Receiver not found! " + id1);
                }
                networkReceiver.receive(buf1, context);
            });
        });
        C2S_TRANSFORMERS.put(id, transformer);
    }

    @Environment(value=EnvType.CLIENT)
    private static void registerS2CReceiver(final class_2960 id, List<PacketTransformer> packetTransformers, NetworkManager.NetworkReceiver receiver) {
        LOGGER.info("Registering S2C receiver with id {}", (Object)id);
        S2C_RECEIVER.put(id, receiver);
        final PacketTransformer transformer = PacketTransformer.concat(packetTransformers);
        ClientPlayNetworking.registerGlobalReceiver((class_2960)id, (ClientPlayNetworking.PlayChannelHandler)new ClientPlayNetworking.PlayChannelHandler(){

            public void receive(class_310 client, class_634 handler, class_2540 buf, PacketSender sender) {
                NetworkManager.PacketContext context = NetworkManagerImpl.context((class_1657)client.field_1724, client, true);
                transformer.inbound(NetworkManager.Side.S2C, id, buf, context, (side, id1, buf1) -> {
                    NetworkManager.NetworkReceiver networkReceiver;
                    NetworkManager.NetworkReceiver networkReceiver2 = networkReceiver = side == NetworkManager.Side.C2S ? C2S_RECEIVER.get(id1) : S2C_RECEIVER.get(id1);
                    if (networkReceiver == null) {
                        throw new IllegalArgumentException("Network Receiver not found! " + id1);
                    }
                    networkReceiver.receive(buf1, context);
                });
            }
        });
        S2C_TRANSFORMERS.put(id, transformer);
    }

    private static NetworkManager.PacketContext context(final class_1657 player, final class_1255<?> taskQueue, final boolean client) {
        return new NetworkManager.PacketContext(){

            @Override
            public class_1657 getPlayer() {
                return player;
            }

            @Override
            public void queue(Runnable runnable) {
                taskQueue.execute(runnable);
            }

            @Override
            public Env getEnvironment() {
                return client ? Env.CLIENT : Env.SERVER;
            }
        };
    }

    public static void collectPackets(PacketSink sink, NetworkManager.Side side, class_2960 id, class_2540 buf) {
        PacketTransformer transformer;
        PacketTransformer packetTransformer = transformer = side == NetworkManager.Side.C2S ? C2S_TRANSFORMERS.get(id) : S2C_TRANSFORMERS.get(id);
        if (transformer != null) {
            transformer.outbound(side, id, buf, (side1, id1, buf1) -> sink.accept(NetworkManagerImpl.toPacket(side1, id1, buf1)));
        } else {
            sink.accept(NetworkManagerImpl.toPacket(side, id, buf));
        }
    }

    public static class_2596<?> toPacket(NetworkManager.Side side, class_2960 id, class_2540 buf) {
        if (side == NetworkManager.Side.C2S) {
            return NetworkManagerImpl.toC2SPacket(id, buf);
        }
        if (side == NetworkManager.Side.S2C) {
            return NetworkManagerImpl.toS2CPacket(id, buf);
        }
        throw new IllegalArgumentException("Invalid side: " + side);
    }

    @Environment(value=EnvType.CLIENT)
    public static boolean canServerReceive(class_2960 id) {
        return ClientPlayNetworking.canSend((class_2960)id);
    }

    public static boolean canPlayerReceive(class_3222 player, class_2960 id) {
        return ServerPlayNetworking.canSend((class_3222)player, (class_2960)id);
    }

    public static class_2596<class_2602> createAddEntityPacket(class_1297 entity) {
        return SpawnEntityPacket.create(entity);
    }

    @Environment(value=EnvType.CLIENT)
    private static class_2596<?> toC2SPacket(class_2960 id, class_2540 buf) {
        return ClientPlayNetworking.createC2SPacket((class_2960)id, (class_2540)buf);
    }

    private static class_2596<?> toS2CPacket(class_2960 id, class_2540 buf) {
        return ServerPlayNetworking.createS2CPacket((class_2960)id, (class_2540)buf);
    }
}

