/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.commandconfig.impl.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.kikugie.commandconfig.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CompletableFuture;

public class ListArgumentType<T, U extends ArgumentType<T>>
implements ArgumentType<List<T>> {
    private static final SimpleCommandExceptionType TOO_FEW_ARGUMENTS_EXCEPTION = new SimpleCommandExceptionType((Message)Reference.translated("commandconfig.response.error.too_few_args"));
    private final U argumentType;
    private final int min;
    private final int max;

    private ListArgumentType(U argumentType, int min, int max) {
        this.argumentType = argumentType;
        this.min = min;
        this.max = max;
    }

    public static <T, U extends ArgumentType<T>> ListArgumentType<T, U> list(U argumentType) {
        return new ListArgumentType<T, U>(argumentType, 1, Integer.MAX_VALUE);
    }

    public static <T, U extends ArgumentType<T>> ListArgumentType<T, U> list(U argumentType, int min) {
        return new ListArgumentType<T, U>(argumentType, min, Integer.MAX_VALUE);
    }

    public static <T, U extends ArgumentType<T>> ListArgumentType<T, U> list(U argumentType, int min, int max) {
        return new ListArgumentType<T, U>(argumentType, min, max);
    }

    public static <T> List<T> getList(CommandContext<?> context, String name) {
        return (List)context.getArgument(name, List.class);
    }

    public List<T> parse(StringReader reader) throws CommandSyntaxException {
        int readAmount;
        ArrayList<Object> parsedArguments = new ArrayList<Object>();
        int cursor = reader.getCursor();
        try {
            for (readAmount = 0; reader.canRead() && readAmount < this.max; ++readAmount) {
                cursor = reader.getCursor();
                parsedArguments.add(this.argumentType.parse(reader));
                if (!reader.canRead()) continue;
                reader.expect(' ');
            }
        }
        catch (CommandSyntaxException e) {
            if (readAmount < this.min) {
                throw e;
            }
            reader.setCursor(cursor);
        }
        if (readAmount < this.min) {
            throw TOO_FEW_ARGUMENTS_EXCEPTION.create();
        }
        return parsedArguments;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        int cursor = reader.getCursor();
        try {
            for (int readAmount = 0; reader.canRead() && readAmount < this.max - 1; ++readAmount) {
                this.argumentType.parse(reader);
                if (!reader.canRead()) continue;
                reader.expect(' ');
                cursor = reader.getCursor();
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return this.argumentType.listSuggestions(context, builder.createOffset(cursor));
    }

    public Collection<String> getExamples() {
        ArrayList lst;
        Collection elementExamples = this.argumentType.getExamples();
        if (elementExamples.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList elementExamplesList = elementExamples instanceof List ? (lst = (ArrayList)elementExamples) : new ArrayList(elementExamples);
        Random rand = new Random(0L);
        String[] ret = new String[3];
        for (int i = 0; i < 3; ++i) {
            StringBuilder sb = new StringBuilder();
            int times = this.min + rand.nextInt(Math.min(this.min + 10, this.max) - this.min + 1);
            for (int j = 0; j < times; ++j) {
                if (j != 0) {
                    sb.append(' ');
                }
                sb.append((String)elementExamplesList.get(rand.nextInt(elementExamples.size())));
            }
            ret[i] = sb.toString();
        }
        return Arrays.asList(ret);
    }
}

