/*
 * Decompiled with CFR 0.152.
 */
package dev.kikugie.commandconfig.impl.option;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import dev.kikugie.commandconfig.Reference;
import dev.kikugie.commandconfig.impl.builders.OptionBuilderImpl;
import net.minecraft.class_2172;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class GenericOptionBuilderImpl<T, S extends class_2172>
extends OptionBuilderImpl<T, S> {
    private final ArgumentType<T> argumentType;
    private final Class<T> valueType;
    private final String typeName;

    public GenericOptionBuilderImpl(String name, ArgumentType<T> argumentType, Class<T> valueType, Class<S> type) {
        super(name, type);
        this.argumentType = argumentType;
        this.valueType = valueType;
        this.typeName = valueType.getSimpleName();
    }

    @Override
    @NotNull
    public LiteralArgumentBuilder<S> build() {
        Validate.notNull((Object)this.printFunc, (String)Reference.optionError(this.name, "No print function for %s \"%s\".\nAdd it using `printFunc` on current or any higher node."), (Object[])new Object[0]);
        if (this.extraNodes.isEmpty()) {
            Validate.notNull((Object)this.valueAccess, (String)Reference.optionError(this.name, "No value access for %s \"%s\".\nAdd it using `valueAccess()`."), (Object[])new Object[0]);
        }
        LiteralArgumentBuilder option = LiteralArgumentBuilder.literal((String)this.name);
        this.extraNodes.forEach(it -> it.accept(option));
        if (this.valueAccess == null) {
            return option;
        }
        option.executes(context -> this.print(context, this.valueAccess.get(context)));
        RequiredArgumentBuilder argument = RequiredArgumentBuilder.argument((String)this.typeName, this.argumentType);
        argument.executes(context -> {
            Object newVal = context.getArgument(this.typeName, this.valueType);
            int result = this.print(context, this.valueAccess.set(context, newVal));
            this.save();
            return result;
        });
        return (LiteralArgumentBuilder)option.then((ArgumentBuilder)argument);
    }
}

