/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.entry;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.settings.EntryIngredientSetting;
import me.shedaniel.rei.impl.Internals;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface EntryIngredient
extends List<EntryStack<?>> {
    public static EntryIngredient empty() {
        return Internals.getEntryIngredientProvider().empty();
    }

    public static <T> EntryIngredient of(EntryStack<T> stack) {
        return Internals.getEntryIngredientProvider().of((EntryStack<?>)stack);
    }

    @SafeVarargs
    public static <T> EntryIngredient of(EntryStack<T> ... stacks) {
        return Internals.getEntryIngredientProvider().of(stacks);
    }

    public static <T> EntryIngredient of(Iterable<? extends EntryStack<? extends T>> stacks) {
        return Internals.getEntryIngredientProvider().of(stacks);
    }

    public static Builder builder() {
        return Internals.getEntryIngredientProvider().builder();
    }

    public static Builder builder(int initialCapacity) {
        return Internals.getEntryIngredientProvider().builder(initialCapacity);
    }

    public static EntryIngredient read(class_2499 tag) {
        if (tag.isEmpty()) {
            return EntryIngredient.empty();
        }
        EntryStack[] stacks = new EntryStack[tag.size()];
        for (int i = 0; i < tag.size(); ++i) {
            stacks[i] = EntryStack.read((class_2487)tag.method_10534(i));
        }
        return Internals.getEntryIngredientProvider().of(stacks);
    }

    public static Collector<EntryStack<?>, ?, EntryIngredient> collector() {
        return Collectors.collectingAndThen(Collectors.toList(), EntryIngredient::of);
    }

    default public class_2499 saveIngredient() {
        return this.save();
    }

    @Deprecated(forRemoval=true)
    public class_2499 save();

    @Deprecated(forRemoval=true)
    default public <T> List<EntryStack<T>> cast() {
        return this.castAsList();
    }

    default public <T> List<EntryStack<T>> castAsList() {
        return this;
    }

    public EntryIngredient filter(Predicate<EntryStack<?>> var1);

    public EntryIngredient map(UnaryOperator<EntryStack<?>> var1);

    @Nullable
    @ApiStatus.Experimental
    public <T> T getSetting(EntryIngredientSetting<T> var1);

    @ApiStatus.Experimental
    public <T> EntryIngredient setting(EntryIngredientSetting<T> var1, T var2);

    @ApiStatus.Experimental
    public static void unifyFocuses(EntryIngredient ... ingredients) {
        UUID uuid = UUID.randomUUID();
        for (EntryIngredient ingredient : ingredients) {
            ingredient.setting(EntryIngredientSetting.FOCUS_UUID, uuid);
        }
    }

    @ApiStatus.NonExtendable
    public static interface Builder {
        public Builder add(EntryStack<?> var1);

        public Builder add(EntryStack<?> ... var1);

        public Builder addAll(Iterable<? extends EntryStack<?>> var1);

        public EntryIngredient build();
    }
}

