/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.commandaliases.command.builder.custom;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import me.flashyreese.mods.commandaliases.CommandAliasesMod;
import me.flashyreese.mods.commandaliases.command.CommandType;
import me.flashyreese.mods.commandaliases.command.Permissions;
import me.flashyreese.mods.commandaliases.command.Scheduler;
import me.flashyreese.mods.commandaliases.command.builder.CommandBuilderDelegate;
import me.flashyreese.mods.commandaliases.command.builder.custom.format.CustomCommand;
import me.flashyreese.mods.commandaliases.command.builder.custom.format.CustomCommandAction;
import me.flashyreese.mods.commandaliases.command.builder.custom.format.CustomCommandChild;
import me.flashyreese.mods.commandaliases.command.builder.custom.format.CustomCommandSuggestionMode;
import me.flashyreese.mods.commandaliases.command.builder.custom.format.CustomCommandSuggestionProvider;
import me.flashyreese.mods.commandaliases.command.impl.ArgumentTypeMapper;
import me.flashyreese.mods.commandaliases.command.impl.FunctionProcessor;
import me.flashyreese.mods.commandaliases.command.impl.InputMapper;
import me.flashyreese.mods.commandaliases.command.loader.AbstractCommandAliasesProvider;
import net.minecraft.class_2172;
import net.minecraft.class_7157;

public abstract class AbstractCustomCommandBuilder<S extends class_2172>
implements CommandBuilderDelegate<S> {
    protected final String filePath;
    protected final CustomCommand commandAliasParent;
    protected final CommandType commandType;
    protected final ArgumentTypeMapper argumentTypeMapper;
    protected final FunctionProcessor<S> functionProcessor;
    protected final InputMapper<S> inputMapper;
    protected final AbstractCommandAliasesProvider<S> abstractCommandAliasesProvider;

    public AbstractCustomCommandBuilder(String filePath, CustomCommand commandAliasParent, AbstractCommandAliasesProvider<S> abstractCommandAliasesProvider, class_7157 registryAccess, CommandType commandType) {
        this.filePath = filePath;
        this.argumentTypeMapper = new ArgumentTypeMapper(registryAccess);
        this.commandAliasParent = commandAliasParent;
        this.abstractCommandAliasesProvider = abstractCommandAliasesProvider;
        this.commandType = commandType;
        this.functionProcessor = new FunctionProcessor<S>(abstractCommandAliasesProvider);
        this.inputMapper = new InputMapper();
    }

    @Override
    public LiteralArgumentBuilder<S> buildCommand(CommandDispatcher<S> dispatcher) {
        return this.buildCommandParent(dispatcher);
    }

    protected LiteralArgumentBuilder<S> buildCommandParent(CommandDispatcher<S> dispatcher) {
        LiteralArgumentBuilder argumentBuilder = this.literal(this.commandAliasParent.getCommand());
        argumentBuilder = this.commandAliasParent.getPermission() > 0 && this.commandAliasParent.getPermission() <= 4 ? (LiteralArgumentBuilder)argumentBuilder.requires(Permissions.require(this.commandAliasParent.getCommand(), this.commandAliasParent.getPermission())) : (LiteralArgumentBuilder)argumentBuilder.requires(Permissions.require(this.commandAliasParent.getCommand(), true));
        if (this.commandAliasParent.isOptional()) {
            argumentBuilder = (LiteralArgumentBuilder)argumentBuilder.executes(context -> this.executeCommand(this.commandAliasParent.getActions(), this.commandAliasParent.getMessage(), dispatcher, context, (List<String>)new ObjectArrayList()));
        }
        if (this.commandAliasParent.getChildren() != null && !this.commandAliasParent.getChildren().isEmpty()) {
            for (CustomCommandChild child : this.commandAliasParent.getChildren()) {
                ArgumentBuilder<S, ?> subArgumentBuilder = this.buildCommandChild(child, dispatcher, (List<String>)new ObjectArrayList(), this.commandAliasParent.getCommand());
                if (subArgumentBuilder == null) continue;
                argumentBuilder = (LiteralArgumentBuilder)argumentBuilder.then(subArgumentBuilder);
            }
        }
        return argumentBuilder;
    }

    protected ArgumentBuilder<S, ?> buildCommandChild(CustomCommandChild child, CommandDispatcher<S> dispatcher, List<String> inputs, String permission) {
        ArgumentBuilder argumentBuilder = null;
        if (child.getChild() == null || child.getChild().isEmpty()) {
            CommandAliasesMod.logger().warn("[{}] {} - Missing Command Child Node Name: {}", new Object[]{this.commandType, this.commandAliasParent.getCommandMode(), this.filePath});
            return null;
        }
        if (child.getType() == null || child.getType().isEmpty()) {
            CommandAliasesMod.logger().warn("[{}] {} - Missing Command Child Node Type of \"{}\": {}", new Object[]{this.commandType, this.commandAliasParent.getCommandMode(), child.getChild(), this.filePath});
            return null;
        }
        if (child.getType().equals("literal")) {
            argumentBuilder = this.literal(child.getChild());
        } else if (child.getType().equals("argument")) {
            if (this.argumentTypeMapper.getArgumentMap().containsKey(child.getArgumentType())) {
                argumentBuilder = this.argument(child.getChild(), this.argumentTypeMapper.getArgumentMap().get(child.getArgumentType()));
                inputs.add(child.getChild());
            } else {
                CommandAliasesMod.logger().error("[{}] {} - Invalid Argument Type of \"{}\": {}", new Object[]{this.commandType, this.commandAliasParent.getCommandMode(), child.getArgumentType(), this.filePath});
            }
        }
        if (argumentBuilder != null) {
            String permissionString = permission + "." + child.getChild();
            argumentBuilder = child.getPermission() > 0 && child.getPermission() <= 4 ? argumentBuilder.requires(Permissions.require(permissionString, child.getPermission())) : argumentBuilder.requires(Permissions.require(permissionString, true));
            if (child.isOptional()) {
                argumentBuilder = argumentBuilder.executes(context -> this.executeCommand(child.getActions(), child.getMessage(), dispatcher, context, inputs));
            }
            if (child.getSuggestionProvider() != null) {
                argumentBuilder = this.buildCommandChildSuggestion(dispatcher, argumentBuilder, child, (List<String>)new ObjectArrayList(inputs));
            }
            if (child.getChildren() != null && !child.getChildren().isEmpty()) {
                for (CustomCommandChild subChild : child.getChildren()) {
                    ArgumentBuilder<S, ?> subArgumentBuilder = this.buildCommandChild(subChild, dispatcher, (List<String>)new ObjectArrayList(inputs), permissionString);
                    if (subArgumentBuilder == null) continue;
                    argumentBuilder = argumentBuilder.then(subArgumentBuilder);
                }
            }
        }
        return argumentBuilder;
    }

    protected int executeCommand(List<CustomCommandAction> actions, String message, CommandDispatcher<S> dispatcher, CommandContext<S> context, List<String> currentInputList) {
        int state = 1;
        if (actions != null && !actions.isEmpty()) {
            state = this.performActions(actions, dispatcher, context, currentInputList);
        }
        if (message != null && !message.isEmpty()) {
            String formatString = this.formatString(context, currentInputList, message);
            this.sendFeedback(context, formatString);
        }
        return state;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ArgumentBuilder<S, ?> buildCommandChildSuggestion(CommandDispatcher<S> dispatcher, ArgumentBuilder<S, ?> argumentBuilder, CustomCommandChild child, List<String> inputs) {
        SuggestionProvider SUGGESTION_PROVIDER;
        block7: {
            if (!(argumentBuilder instanceof RequiredArgumentBuilder)) {
                return argumentBuilder;
            }
            CustomCommandSuggestionProvider suggestionProvider = child.getSuggestionProvider();
            if (suggestionProvider.getSuggestionMode() == null) {
                CommandAliasesMod.logger().warn("[{}] {} - Missing suggestion mode: {}", new Object[]{this.commandType, this.commandAliasParent.getCommandMode(), this.filePath});
                return argumentBuilder;
            }
            if (suggestionProvider.getSuggestion() == null || suggestionProvider.getSuggestion().isEmpty()) {
                CommandAliasesMod.logger().warn("[{}] {} - Missing suggestion: {}", new Object[]{this.commandType, this.commandAliasParent.getCommandMode(), this.filePath});
                return argumentBuilder;
            }
            if (Arrays.stream(CustomCommandSuggestionMode.values()).filter(value -> suggestionProvider.getSuggestionMode() == value).count() != 1L) {
                CommandAliasesMod.logger().error("[{}] {} - Invalid suggestion mode \"{}\": {}", new Object[]{this.commandType, this.commandAliasParent.getCommandMode(), suggestionProvider.getSuggestionMode(), this.filePath});
                return argumentBuilder;
            }
            if (suggestionProvider.getSuggestionMode() == CustomCommandSuggestionMode.COMMAND_LIST_LOOKUP) {
                ArgumentBuilder argumentBuilder2;
                CommandNode redirect = dispatcher.findNode((Collection)Lists.newArrayList((Object[])suggestionProvider.getSuggestion().split(" ")));
                if (redirect != null && (argumentBuilder2 = redirect.createBuilder()) instanceof RequiredArgumentBuilder) {
                    RequiredArgumentBuilder requiredArgumentBuilder = (RequiredArgumentBuilder)argumentBuilder2;
                    SUGGESTION_PROVIDER = requiredArgumentBuilder.getSuggestionsProvider();
                    break block7;
                } else {
                    CommandAliasesMod.logger().error("[{}] {} - Invalid suggestion \"{}\": {}", new Object[]{this.commandType, this.commandAliasParent.getCommandMode(), suggestionProvider.getSuggestion(), this.filePath});
                    return argumentBuilder;
                }
            }
            SUGGESTION_PROVIDER = suggestionProvider.getSuggestionMode() == CustomCommandSuggestionMode.JSON_LIST ? (context, builder) -> {
                long start = System.nanoTime();
                String formattedSuggestion = this.formatString(context, inputs, suggestionProvider.getSuggestion());
                List suggestions = (List)new Gson().fromJson(formattedSuggestion, new TypeToken<List<String>>(){}.getType());
                long end = System.nanoTime();
                if (CommandAliasesMod.options().debugSettings.showProcessingTime) {
                    CommandAliasesMod.logger().info("\n\t======================================================\n\tSuggestion Provider: {}\n\tProcessing time: {}ms\n\t======================================================", (Object)formattedSuggestion, (Object)((double)(end - start) / 1000000.0));
                }
                return class_2172.method_9264(suggestions.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)builder);
            } : (context, builder) -> {
                ObjectArrayList suggestions = new ObjectArrayList();
                long start = System.nanoTime();
                String formattedSuggestion = this.formatString(context, inputs, suggestionProvider.getSuggestion());
                this.abstractCommandAliasesProvider.getDatabase().map().forEach((arg_0, arg_1) -> AbstractCustomCommandBuilder.lambda$buildCommandChildSuggestion$4(suggestionProvider, formattedSuggestion, (List)suggestions, arg_0, arg_1));
                long end = System.nanoTime();
                if (CommandAliasesMod.options().debugSettings.showProcessingTime) {
                    CommandAliasesMod.logger().info("\n\t======================================================\n\tSuggestion Provider: {}\n\t\"Processing time: {}ms\n\t======================================================", (Object)formattedSuggestion, (Object)((double)(end - start) / 1000000.0));
                }
                return class_2172.method_9264(suggestions.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)builder);
            };
        }
        RequiredArgumentBuilder requiredArgumentBuilder = (RequiredArgumentBuilder)argumentBuilder;
        return requiredArgumentBuilder.suggests(SUGGESTION_PROVIDER);
    }

    protected int performActions(List<CustomCommandAction> actions, CommandDispatcher<S> dispatcher, CommandContext<S> context, List<String> currentInputList) {
        LinkedList<CustomCommandAction> customCommandActionQueue = new LinkedList<CustomCommandAction>(actions);
        return this.scheduleAction(customCommandActionQueue, System.currentTimeMillis(), dispatcher, context, currentInputList);
    }

    private int scheduleAction(Queue<CustomCommandAction> customCommandActionQueue, long triggerTime, CommandDispatcher<S> dispatcher, CommandContext<S> context, List<String> currentInputList) {
        AtomicInteger state = new AtomicInteger();
        if (customCommandActionQueue.isEmpty()) {
            return 1;
        }
        CustomCommandAction action = customCommandActionQueue.poll();
        String eventName = "generic";
        if (action.getId() != null && !action.getId().isEmpty()) {
            eventName = this.formatString(context, currentInputList, action.getId());
        }
        if (action.getStartTime() != null && !action.getStartTime().isEmpty()) {
            String time = this.formatString(context, currentInputList, action.getStartTime());
            triggerTime = System.currentTimeMillis() + Long.parseLong(time);
        }
        this.abstractCommandAliasesProvider.getScheduler().addEvent(new Scheduler.Event(triggerTime, eventName, () -> {
            if (action.getCommand() != null && action.getCommandType() != null) {
                long startFormat = System.nanoTime();
                String actionCommand = this.formatString(context, currentInputList, action.getCommand());
                long endFormat = System.nanoTime();
                try {
                    state.set(this.dispatcherExecute(action, dispatcher, context, actionCommand));
                }
                catch (CommandSyntaxException e) {
                    if (CommandAliasesMod.options().debugSettings.debugMode) {
                        CommandAliasesMod.logger().error("\n\t======================================================\n\tFailed to process command\n\tOriginal Action Command: {}\n\tOriginal Action Command Type: {}\n\tPost Processed Action Command: {}\n\t======================================================", new Object[]{action.getCommand(), action.getCommandType(), actionCommand});
                        String output = e.getLocalizedMessage();
                        this.sendFeedback(context, output);
                    }
                    e.printStackTrace();
                }
                long endExecution = System.nanoTime();
                if (CommandAliasesMod.options().debugSettings.showProcessingTime) {
                    CommandAliasesMod.logger().info("\n\t======================================================\n\tOriginal Action Command: {}\n\tOriginal Action Command Type: {}\n\tPost Processed Action Command: {}\n\tFormatting time: {}ms\n\tExecuting time: {}ms\n\t======================================================", new Object[]{action.getCommand(), action.getCommandType(), actionCommand, (double)(endFormat - startFormat) / 1000000.0, (double)(endExecution - endFormat) / 1000000.0});
                }
                if (state.get() != 1) {
                    if (action.getMessageIfUnsuccessful() != null) {
                        String message = this.formatString(context, currentInputList, action.getMessageIfUnsuccessful());
                        this.sendFeedback(context, message);
                    }
                    if (action.getActionsIfUnsuccessful() != null && !action.getActionsIfUnsuccessful().isEmpty()) {
                        LinkedList<CustomCommandAction> unsuccessfulActionsQueue = new LinkedList<CustomCommandAction>(action.getActionsIfUnsuccessful());
                        state.set(this.scheduleAction(unsuccessfulActionsQueue, System.currentTimeMillis(), dispatcher, context, currentInputList));
                    }
                    if (action.isRequireSuccess()) {
                        customCommandActionQueue.clear();
                    }
                } else {
                    if (action.getMessageIfSuccessful() != null) {
                        String message = this.formatString(context, currentInputList, action.getMessageIfSuccessful());
                        this.sendFeedback(context, message);
                    }
                    if (action.getActionsIfSuccessful() != null && !action.getActionsIfSuccessful().isEmpty()) {
                        LinkedList<CustomCommandAction> successfulActionsQueue = new LinkedList<CustomCommandAction>(action.getActionsIfSuccessful());
                        state.set(this.scheduleAction(successfulActionsQueue, System.currentTimeMillis(), dispatcher, context, currentInputList));
                    }
                }
            }
            if (action.getMessage() != null) {
                String message = this.formatString(context, currentInputList, action.getMessage());
                this.sendFeedback(context, message);
            }
            state.set(this.scheduleAction(customCommandActionQueue, System.currentTimeMillis(), dispatcher, context, currentInputList));
        }));
        return state.get();
    }

    protected String formatString(CommandContext<S> context, List<String> currentInputList, String string) {
        string = this.inputMapper.formatAndMapInputs(string, context, currentInputList, this.argumentTypeMapper);
        string = this.functionProcessor.processFunctions(string, (class_2172)context.getSource());
        string = string.trim();
        return string;
    }

    protected abstract void sendFeedback(CommandContext<S> var1, String var2);

    protected abstract int dispatcherExecute(CustomCommandAction var1, CommandDispatcher<S> var2, CommandContext<S> var3, String var4) throws CommandSyntaxException;

    private static /* synthetic */ void lambda$buildCommandChildSuggestion$4(CustomCommandSuggestionProvider suggestionProvider, String formattedSuggestion, List suggestions, String key, String value) {
        if (!(suggestionProvider.getSuggestionMode() == CustomCommandSuggestionMode.DATABASE_STARTS_WITH && key.startsWith(formattedSuggestion) || suggestionProvider.getSuggestionMode() == CustomCommandSuggestionMode.DATABASE_ENDS_WITH && key.endsWith(formattedSuggestion) || suggestionProvider.getSuggestionMode() == CustomCommandSuggestionMode.DATABASE_CONTAINS && key.contains(formattedSuggestion))) {
            return;
        }
        suggestions.add(value);
    }
}

