/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.commandaliases.command.builder.reassign;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import me.flashyreese.mods.commandaliases.CommandAliasesMod;
import me.flashyreese.mods.commandaliases.command.CommandType;
import me.flashyreese.mods.commandaliases.command.builder.CommandBuilderDelegate;
import me.flashyreese.mods.commandaliases.command.builder.reassign.format.ReassignCommand;
import net.minecraft.class_2172;

public class ReassignCommandBuilder<S extends class_2172>
implements CommandBuilderDelegate<S> {
    protected final String filePath;
    protected final ReassignCommand command;
    protected final Map<String, String> reassignCommandMap;
    protected final List<String> loadedCommands;
    private final Field literalCommandNodeLiteralField;
    private final CommandType commandType;

    public ReassignCommandBuilder(String filePath, ReassignCommand command, Field literalCommandNodeLiteralField, Map<String, String> reassignCommandMap, List<String> loadedCommands, CommandType commandType) {
        this.filePath = filePath;
        this.command = command;
        this.literalCommandNodeLiteralField = literalCommandNodeLiteralField;
        this.reassignCommandMap = reassignCommandMap;
        this.loadedCommands = loadedCommands;
        this.commandType = commandType;
    }

    @Override
    public LiteralArgumentBuilder<S> buildCommand(CommandDispatcher<S> dispatcher) {
        if (this.reassignCommand(this.command, dispatcher)) {
            String command = this.command.getCommand().trim();
            String reassignTo = this.command.getReassignTo().trim();
            this.reassignCommandMap.put(command, reassignTo);
            this.loadedCommands.add(command);
        }
        return null;
    }

    protected boolean reassignCommand(ReassignCommand cmd, CommandDispatcher<S> dispatcher) {
        String command = cmd.getCommand().trim();
        String reassignTo = cmd.getReassignTo().trim();
        if (command.contains(" ")) {
            CommandAliasesMod.logger().error("[{}] {} - \"command\" field must not contain spaces, skipping \"{}\": {}", new Object[]{this.commandType, cmd.getCommandMode(), command, this.filePath});
            return false;
        }
        if (reassignTo.contains(" ")) {
            CommandAliasesMod.logger().error("[{}] {} - \"reassignTo\" field must not contain spaces, skipping \"{}\": {}", new Object[]{this.commandType, cmd.getCommandMode(), reassignTo, this.filePath});
            return false;
        }
        CommandNode commandNode = dispatcher.getRoot().getChildren().stream().filter(node -> node.getName().equals(command)).findFirst().orElse(null);
        CommandNode commandReassignNode = dispatcher.getRoot().getChildren().stream().filter(node -> node.getName().equals(reassignTo)).findFirst().orElse(null);
        if (commandNode != null && commandReassignNode == null) {
            dispatcher.getRoot().getChildren().remove(commandNode);
            try {
                this.literalCommandNodeLiteralField.set(commandNode, reassignTo);
            }
            catch (IllegalAccessException e) {
                dispatcher.getRoot().addChild(commandNode);
                e.printStackTrace();
                CommandAliasesMod.logger().error("[{}] {} - Failed to modify command literal \"{}\", skipping: {}", new Object[]{this.commandType, cmd.getCommandMode(), command, this.filePath});
                return false;
            }
            dispatcher.getRoot().addChild(commandNode);
            CommandAliasesMod.logger().info("[{}] {} - Command \"{}\" has been reassigned to \"{}\": {}", new Object[]{this.commandType, cmd.getCommandMode(), command, reassignTo, this.filePath});
            return true;
        }
        return false;
    }
}

