/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.commandaliases.command.builder.redirect;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.flashyreese.mods.commandaliases.CommandAliasesMod;
import me.flashyreese.mods.commandaliases.command.CommandMode;
import me.flashyreese.mods.commandaliases.command.CommandType;
import me.flashyreese.mods.commandaliases.command.builder.CommandBuilderDelegate;
import me.flashyreese.mods.commandaliases.command.builder.redirect.format.RedirectCommand;
import net.minecraft.class_2172;

public class CommandRedirectBuilder<S extends class_2172>
implements CommandBuilderDelegate<S> {
    private final String filePath;
    private final RedirectCommand command;
    private final CommandType commandType;

    public CommandRedirectBuilder(String filePath, RedirectCommand command, CommandType commandType) {
        this.filePath = filePath;
        this.command = command;
        this.commandType = commandType;
    }

    @Override
    public LiteralArgumentBuilder<S> buildCommand(CommandDispatcher<S> dispatcher) {
        return this.parseCommand(this.command, dispatcher);
    }

    private LiteralArgumentBuilder<S> parseCommand(RedirectCommand cmd, CommandDispatcher<S> dispatcher) {
        LiteralArgumentBuilder commandBuilder = null;
        String command = cmd.getCommand().trim();
        String redirectTo = cmd.getRedirectTo().trim();
        if (command.isEmpty() || redirectTo.isEmpty()) {
            CommandAliasesMod.logger().error("[{}] {} - Empty command/redirect field: {}", new Object[]{this.commandType, cmd.getCommandMode(), this.filePath});
            return null;
        }
        CommandNode redirect = dispatcher.findNode((Collection)Lists.newArrayList((Object[])redirectTo.split(" ")));
        if (redirect == null) {
            CommandAliasesMod.logger().error("[{}] {} - Could not find existing command \"{}\": {}", new Object[]{this.commandType, cmd.getCommandMode(), redirectTo, this.filePath});
            return null;
        }
        List<String> literals = Arrays.asList(command.split(" "));
        Optional topLevelCommand = literals.stream().findFirst();
        if (topLevelCommand.isPresent() && dispatcher.findNode(List.of((String)topLevelCommand.get())) != null && literals.size() == 1) {
            CommandAliasesMod.logger().error("[{}] {} - Existing top level command \"{}\": {}", new Object[]{this.commandType, cmd.getCommandMode(), command, this.filePath});
            return null;
        }
        Collections.reverse(literals);
        for (String literal : literals) {
            if (commandBuilder != null) {
                commandBuilder = (LiteralArgumentBuilder)this.literal(literal).then(commandBuilder);
                continue;
            }
            if (this.command.getCommandMode() == CommandMode.COMMAND_REDIRECT) {
                commandBuilder = (LiteralArgumentBuilder)this.literal(literal).redirect(redirect);
                continue;
            }
            if (this.command.getCommandMode() != CommandMode.COMMAND_REDIRECT_NOARG) continue;
            commandBuilder = (LiteralArgumentBuilder)this.literal(literal).executes(redirect.getCommand());
        }
        return commandBuilder;
    }
}

