/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.commandaliases.command.impl;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.flashyreese.mods.commandaliases.CommandAliasesMod;
import me.flashyreese.mods.commandaliases.command.loader.AbstractCommandAliasesProvider;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_3222;
import net.minecraft.class_742;

public class FunctionProcessor<S extends class_2172> {
    private final Pattern singleArgumentFunction = Pattern.compile("\\$(?<functionName>\\w+?)\\((?<arg>[+-]?(\\d+([.]\\d*)?|[.]\\d+)?|[\\w._]+?)\\)");
    private final Map<String, BiFunction<class_2172, String, String>> functionMap = new Object2ObjectOpenHashMap();
    private final AbstractCommandAliasesProvider<S> abstractCommandAliasesProvider;

    public FunctionProcessor(AbstractCommandAliasesProvider<S> abstractCommandAliasesProvider) {
        this.abstractCommandAliasesProvider = abstractCommandAliasesProvider;
        this.registerFunctions();
    }

    public void registerFunctions() {
        this.functionMap.put("executor_name", (commandSource, input) -> {
            if (commandSource instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)commandSource;
                return serverCommandSource.method_9214();
            }
            if (commandSource instanceof FabricClientCommandSource) {
                FabricClientCommandSource clientCommandSource = (FabricClientCommandSource)commandSource;
                return clientCommandSource.getPlayer().method_5820();
            }
            return null;
        });
        this.functionMap.put("random", (commandSource, input) -> {
            block3: {
                if (input != null && !input.isEmpty()) {
                    try {
                        long seed = Long.parseLong(input);
                        return String.valueOf(new Random(seed).nextInt());
                    }
                    catch (NumberFormatException e) {
                        if (!CommandAliasesMod.options().debugSettings.debugMode) break block3;
                        CommandAliasesMod.logger().error("Parsing exception: {}", (Object)e.getMessage());
                    }
                }
            }
            return String.valueOf(new Random().nextInt());
        });
        this.functionMap.put("is_online", (commandSource, input) -> {
            if (commandSource instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)commandSource;
                return String.valueOf(serverCommandSource.method_9225().method_18456().stream().anyMatch(serverPlayerEntity -> serverPlayerEntity.method_5820().equals(input)));
            }
            if (commandSource instanceof FabricClientCommandSource) {
                FabricClientCommandSource clientCommandSource = (FabricClientCommandSource)commandSource;
                return String.valueOf(clientCommandSource.getWorld().method_18456().stream().anyMatch(serverPlayerEntity -> serverPlayerEntity.method_5820().equals(input)));
            }
            return "false";
        });
        this.functionMap.put("get_time", (commandSource, input) -> {
            if (commandSource instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)commandSource;
                return String.valueOf(serverCommandSource.method_9225().method_8510());
            }
            if (commandSource instanceof FabricClientCommandSource) {
                FabricClientCommandSource clientCommandSource = (FabricClientCommandSource)commandSource;
                return String.valueOf(clientCommandSource.getWorld().method_8510());
            }
            return null;
        });
        this.functionMap.put("get_time_of_day", (commandSource, input) -> {
            if (commandSource instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)commandSource;
                return String.valueOf(serverCommandSource.method_9225().method_8532());
            }
            if (commandSource instanceof FabricClientCommandSource) {
                FabricClientCommandSource clientCommandSource = (FabricClientCommandSource)commandSource;
                return String.valueOf(clientCommandSource.getWorld().method_8532());
            }
            return null;
        });
        this.functionMap.put("get_lunar_time", (commandSource, input) -> {
            if (commandSource instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)commandSource;
                return String.valueOf(serverCommandSource.method_9225().method_30271());
            }
            if (commandSource instanceof FabricClientCommandSource) {
                FabricClientCommandSource clientCommandSource = (FabricClientCommandSource)commandSource;
                return String.valueOf(clientCommandSource.getWorld().method_30271());
            }
            return null;
        });
        this.functionMap.put("get_dimension", (commandSource, input) -> {
            FabricClientCommandSource clientCommandSource;
            Optional<class_742> optionalPlayer;
            if (commandSource instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)commandSource;
                Optional<class_3222> optionalPlayer2 = serverCommandSource.method_9225().method_18456().stream().filter(serverPlayerEntity -> serverPlayerEntity.method_5820().equals(input)).findFirst();
                if (optionalPlayer2.isPresent()) {
                    return optionalPlayer2.get().method_5770().method_27983().method_29177().toString();
                }
            } else if (commandSource instanceof FabricClientCommandSource && (optionalPlayer = (clientCommandSource = (FabricClientCommandSource)commandSource).getWorld().method_18456().stream().filter(clientPlayerEntity -> clientPlayerEntity.method_5820().equals(input)).findFirst()).isPresent()) {
                return optionalPlayer.get().method_5770().method_27983().method_29177().toString();
            }
            return null;
        });
        this.functionMap.put("get_world", (commandSource, input) -> {
            FabricClientCommandSource clientCommandSource;
            Optional<class_742> optionalPlayer;
            if (commandSource instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)commandSource;
                Optional<class_3222> optionalPlayer2 = serverCommandSource.method_9225().method_18456().stream().filter(serverPlayerEntity -> serverPlayerEntity.method_5820().equals(input)).findFirst();
                if (optionalPlayer2.isPresent()) {
                    return optionalPlayer2.get().method_5770().method_8597().comp_655().toString();
                }
            } else if (commandSource instanceof FabricClientCommandSource && (optionalPlayer = (clientCommandSource = (FabricClientCommandSource)commandSource).getWorld().method_18456().stream().filter(clientPlayerEntity -> clientPlayerEntity.method_5820().equals(input)).findFirst()).isPresent()) {
                return optionalPlayer.get().method_5770().method_8597().comp_655().toString();
            }
            return null;
        });
        this.functionMap.put("get_block_pos_x", (commandSource, input) -> {
            FabricClientCommandSource clientCommandSource;
            Optional<class_742> optionalPlayer;
            if (commandSource instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)commandSource;
                Optional<class_3222> optionalPlayer2 = serverCommandSource.method_9225().method_18456().stream().filter(serverPlayerEntity -> serverPlayerEntity.method_5820().equals(input)).findFirst();
                if (optionalPlayer2.isPresent()) {
                    return String.valueOf(optionalPlayer2.get().method_31477());
                }
            } else if (commandSource instanceof FabricClientCommandSource && (optionalPlayer = (clientCommandSource = (FabricClientCommandSource)commandSource).getWorld().method_18456().stream().filter(clientPlayerEntity -> clientPlayerEntity.method_5820().equals(input)).findFirst()).isPresent()) {
                return String.valueOf(optionalPlayer.get().method_31477());
            }
            return null;
        });
        this.functionMap.put("get_block_pos_y", (commandSource, input) -> {
            FabricClientCommandSource clientCommandSource;
            Optional<class_742> optionalPlayer;
            if (commandSource instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)commandSource;
                Optional<class_3222> optionalPlayer2 = serverCommandSource.method_9225().method_18456().stream().filter(serverPlayerEntity -> serverPlayerEntity.method_5820().equals(input)).findFirst();
                if (optionalPlayer2.isPresent()) {
                    return String.valueOf(optionalPlayer2.get().method_31478());
                }
            } else if (commandSource instanceof FabricClientCommandSource && (optionalPlayer = (clientCommandSource = (FabricClientCommandSource)commandSource).getWorld().method_18456().stream().filter(clientPlayerEntity -> clientPlayerEntity.method_5820().equals(input)).findFirst()).isPresent()) {
                return String.valueOf(optionalPlayer.get().method_31478());
            }
            return null;
        });
        this.functionMap.put("get_block_pos_z", (commandSource, input) -> {
            FabricClientCommandSource clientCommandSource;
            Optional<class_742> optionalPlayer;
            if (commandSource instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)commandSource;
                Optional<class_3222> optionalPlayer2 = serverCommandSource.method_9225().method_18456().stream().filter(serverPlayerEntity -> serverPlayerEntity.method_5820().equals(input)).findFirst();
                if (optionalPlayer2.isPresent()) {
                    return String.valueOf(optionalPlayer2.get().method_31479());
                }
            } else if (commandSource instanceof FabricClientCommandSource && (optionalPlayer = (clientCommandSource = (FabricClientCommandSource)commandSource).getWorld().method_18456().stream().filter(clientPlayerEntity -> clientPlayerEntity.method_5820().equals(input)).findFirst()).isPresent()) {
                return String.valueOf(optionalPlayer.get().method_31479());
            }
            return null;
        });
        this.functionMap.put("get_yaw", (commandSource, input) -> {
            FabricClientCommandSource clientCommandSource;
            Optional<class_742> optionalPlayer;
            if (commandSource instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)commandSource;
                Optional<class_3222> optionalPlayer2 = serverCommandSource.method_9225().method_18456().stream().filter(serverPlayerEntity -> serverPlayerEntity.method_5820().equals(input)).findFirst();
                if (optionalPlayer2.isPresent()) {
                    return String.valueOf(optionalPlayer2.get().method_36454());
                }
            } else if (commandSource instanceof FabricClientCommandSource && (optionalPlayer = (clientCommandSource = (FabricClientCommandSource)commandSource).getWorld().method_18456().stream().filter(clientPlayerEntity -> clientPlayerEntity.method_5820().equals(input)).findFirst()).isPresent()) {
                return String.valueOf(optionalPlayer.get().method_36454());
            }
            return null;
        });
        this.functionMap.put("get_pitch", (commandSource, input) -> {
            FabricClientCommandSource clientCommandSource;
            Optional<class_742> optionalPlayer;
            if (commandSource instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)commandSource;
                Optional<class_3222> optionalPlayer2 = serverCommandSource.method_9225().method_18456().stream().filter(serverPlayerEntity -> serverPlayerEntity.method_5820().equals(input)).findFirst();
                if (optionalPlayer2.isPresent()) {
                    return String.valueOf(optionalPlayer2.get().method_36455());
                }
            } else if (commandSource instanceof FabricClientCommandSource && (optionalPlayer = (clientCommandSource = (FabricClientCommandSource)commandSource).getWorld().method_18456().stream().filter(clientPlayerEntity -> clientPlayerEntity.method_5820().equals(input)).findFirst()).isPresent()) {
                return String.valueOf(optionalPlayer.get().method_36455());
            }
            return null;
        });
        this.functionMap.put("get_pos_x", (commandSource, input) -> {
            FabricClientCommandSource clientCommandSource;
            Optional<class_742> optionalPlayer;
            if (commandSource instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)commandSource;
                Optional<class_3222> optionalPlayer2 = serverCommandSource.method_9225().method_18456().stream().filter(serverPlayerEntity -> serverPlayerEntity.method_5820().equals(input)).findFirst();
                if (optionalPlayer2.isPresent()) {
                    return String.valueOf(optionalPlayer2.get().method_23317());
                }
            } else if (commandSource instanceof FabricClientCommandSource && (optionalPlayer = (clientCommandSource = (FabricClientCommandSource)commandSource).getWorld().method_18456().stream().filter(clientPlayerEntity -> clientPlayerEntity.method_5820().equals(input)).findFirst()).isPresent()) {
                return String.valueOf(optionalPlayer.get().method_23317());
            }
            return null;
        });
        this.functionMap.put("get_pos_y", (commandSource, input) -> {
            FabricClientCommandSource clientCommandSource;
            Optional<class_742> optionalPlayer;
            if (commandSource instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)commandSource;
                Optional<class_3222> optionalPlayer2 = serverCommandSource.method_9225().method_18456().stream().filter(serverPlayerEntity -> serverPlayerEntity.method_5820().equals(input)).findFirst();
                if (optionalPlayer2.isPresent()) {
                    return String.valueOf(optionalPlayer2.get().method_23318());
                }
            } else if (commandSource instanceof FabricClientCommandSource && (optionalPlayer = (clientCommandSource = (FabricClientCommandSource)commandSource).getWorld().method_18456().stream().filter(clientPlayerEntity -> clientPlayerEntity.method_5820().equals(input)).findFirst()).isPresent()) {
                return String.valueOf(optionalPlayer.get().method_23318());
            }
            return null;
        });
        this.functionMap.put("get_pos_z", (commandSource, input) -> {
            FabricClientCommandSource clientCommandSource;
            Optional<class_742> optionalPlayer;
            if (commandSource instanceof class_2168) {
                class_2168 serverCommandSource = (class_2168)commandSource;
                Optional<class_3222> optionalPlayer2 = serverCommandSource.method_9225().method_18456().stream().filter(serverPlayerEntity -> serverPlayerEntity.method_5820().equals(input)).findFirst();
                if (optionalPlayer2.isPresent()) {
                    return String.valueOf(optionalPlayer2.get().method_23321());
                }
            } else if (commandSource instanceof FabricClientCommandSource && (optionalPlayer = (clientCommandSource = (FabricClientCommandSource)commandSource).getWorld().method_18456().stream().filter(clientPlayerEntity -> clientPlayerEntity.method_5820().equals(input)).findFirst()).isPresent()) {
                return String.valueOf(optionalPlayer.get().method_23321());
            }
            return null;
        });
        this.functionMap.put("get_database_contains", (commandSource, input) -> {
            for (Map.Entry<String, String> entry : this.abstractCommandAliasesProvider.getDatabase().map().entrySet()) {
                if (!entry.getKey().contains((CharSequence)input)) continue;
                return "true";
            }
            return "false";
        });
        this.functionMap.put("get_database_first_starts_with", (commandSource, input) -> {
            for (Map.Entry<String, String> entry : this.abstractCommandAliasesProvider.getDatabase().map().entrySet()) {
                if (!entry.getKey().startsWith((String)input)) continue;
                return entry.getValue();
            }
            if (CommandAliasesMod.options().debugSettings.debugMode) {
                CommandAliasesMod.logger().error("Empty result: {}", input);
            }
            return null;
        });
        this.functionMap.put("get_database_first_ends_with", (commandSource, input) -> {
            for (Map.Entry<String, String> entry : this.abstractCommandAliasesProvider.getDatabase().map().entrySet()) {
                if (!entry.getKey().endsWith((String)input)) continue;
                return entry.getValue();
            }
            if (CommandAliasesMod.options().debugSettings.debugMode) {
                CommandAliasesMod.logger().error("Empty result: {}", input);
            }
            return null;
        });
        this.functionMap.put("get_database_first_contains", (commandSource, input) -> {
            for (Map.Entry<String, String> entry : this.abstractCommandAliasesProvider.getDatabase().map().entrySet()) {
                if (!entry.getKey().contains((CharSequence)input)) continue;
                return entry.getValue();
            }
            if (CommandAliasesMod.options().debugSettings.debugMode) {
                CommandAliasesMod.logger().error("Empty result: {}", input);
            }
            return null;
        });
        this.functionMap.put("get_database_value", (commandSource, input) -> {
            String value = this.abstractCommandAliasesProvider.getDatabase().read((String)input);
            if (value != null) {
                return value;
            }
            if (CommandAliasesMod.options().debugSettings.debugMode) {
                CommandAliasesMod.logger().error("Invalid database key: {}", input);
            }
            return null;
        });
    }

    public String processFunctions(String original, class_2172 commandSource) {
        String modified = original;
        Matcher matcher = this.singleArgumentFunction.matcher(modified);
        while (matcher.find()) {
            String functionName = matcher.group("functionName");
            String arg = matcher.group("arg");
            if (!this.functionMap.containsKey(functionName)) {
                CommandAliasesMod.logger().error("Invalid function of `{}` in `{}`. Please check the functionMap", (Object)functionName, (Object)original);
                throw new IllegalArgumentException("Invalid function name : " + functionName);
            }
            BiFunction<class_2172, String, String> function = this.functionMap.get(functionName);
            String value = function.apply(commandSource, arg);
            modified = modified.replace(matcher.group(), Objects.requireNonNullElse(value, "null"));
            matcher = this.singleArgumentFunction.matcher(modified);
        }
        return modified;
    }

    public Map<String, BiFunction<class_2172, String, String>> getFunctionMap() {
        return this.functionMap;
    }
}

