/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.commandaliases.command.impl;

import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.flashyreese.mods.commandaliases.CommandAliasesMod;
import me.flashyreese.mods.commandaliases.command.impl.ArgumentTypeMapper;
import me.flashyreese.mods.commandaliases.command.impl.FormattingTypeProcessor;

public class InputMapper<S> {
    protected final FormattingTypeProcessor formattingTypeMap = new FormattingTypeProcessor();
    private final Pattern placeholderWithFormattingPattern = Pattern.compile("\\{\\{(?<placeholder>\\w+)?(@(?<formattingType>\\w+))?}}");

    /*
     * Enabled aggressive block sorting
     */
    public String formatAndMapInputs(String original, CommandContext<S> context, List<String> inputList, ArgumentTypeMapper argumentTypeMapper) {
        String modified = original;
        Matcher matcher = this.placeholderWithFormattingPattern.matcher(modified);
        while (matcher.find()) {
            String placeholder = matcher.group("placeholder");
            if (!inputList.contains(placeholder)) {
                CommandAliasesMod.logger().error("Invalid placeholder of `{}` in `{}`", (Object)placeholder, (Object)original);
                return modified;
            }
            String formattingType = matcher.group("formattingType");
            String value = argumentTypeMapper.getInputString(context, placeholder);
            if (formattingType != null) {
                if (!this.formattingTypeMap.getFormatTypeMap().containsKey(formattingType)) {
                    CommandAliasesMod.logger().error("Invalid formatting type of `{}` in `{}`", (Object)formattingType, (Object)original);
                    return modified;
                }
                value = this.formattingTypeMap.getFormatTypeMap().get(formattingType).apply(value);
            }
            modified = modified.replace(matcher.group(), value);
            matcher = this.placeholderWithFormattingPattern.matcher(modified);
        }
        return modified;
    }
}

