/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.commandaliases.command.loader;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.dataformat.toml.TomlMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import me.flashyreese.mods.commandaliases.CommandAliasesMod;
import me.flashyreese.mods.commandaliases.command.CommandAlias;
import me.flashyreese.mods.commandaliases.command.CommandMode;
import me.flashyreese.mods.commandaliases.command.CommandType;
import me.flashyreese.mods.commandaliases.command.Permissions;
import me.flashyreese.mods.commandaliases.command.Scheduler;
import me.flashyreese.mods.commandaliases.command.builder.custom.format.CustomCommand;
import me.flashyreese.mods.commandaliases.command.builder.reassign.ReassignCommandBuilder;
import me.flashyreese.mods.commandaliases.command.builder.reassign.format.ReassignCommand;
import me.flashyreese.mods.commandaliases.command.builder.redirect.CommandRedirectBuilder;
import me.flashyreese.mods.commandaliases.command.builder.redirect.format.RedirectCommand;
import me.flashyreese.mods.commandaliases.math.ExtendedDoubleEvaluator;
import me.flashyreese.mods.commandaliases.math.SimpleBooleanEvaluator;
import me.flashyreese.mods.commandaliases.storage.database.AbstractDatabase;
import me.flashyreese.mods.commandaliases.util.TreeNode;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCommandAliasesProvider<S extends class_2172> {
    private final ObjectMapper jsonMapper = new JsonMapper();
    private final ObjectMapper json5Mapper = new JsonMapper(JsonFactory.builder().enable(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES).enable(JsonReadFeature.ALLOW_TRAILING_COMMA).enable(JsonReadFeature.ALLOW_SINGLE_QUOTES).enable(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER).enable(JsonReadFeature.ALLOW_NON_NUMERIC_NUMBERS).enable(JsonReadFeature.ALLOW_JAVA_COMMENTS).enable(JsonReadFeature.ALLOW_LEADING_DECIMAL_POINT_FOR_NUMBERS).enable(JsonReadFeature.ALLOW_TRAILING_DECIMAL_POINT_FOR_NUMBERS).enable(JsonReadFeature.ALLOW_LEADING_PLUS_SIGN_FOR_NUMBERS).build());
    private final ObjectMapper tomlMapper = new TomlMapper();
    private final ObjectMapper yamlMapper = new YAMLMapper();
    private final Map<String, CommandAlias> commands = new Object2ObjectOpenHashMap();
    private final List<String> loadedCommands = new ObjectArrayList();
    private final Map<String, String> reassignedCommandMap = new Object2ObjectOpenHashMap();
    private final Path commandsDirectory;
    private final Field literalCommandNodeLiteralField;
    private final String rootCommand;
    private final CommandType commandType;
    private AbstractDatabase<String, String> database;
    private Scheduler scheduler;

    public AbstractCommandAliasesProvider(Path commandsDirectory, Field literalCommandNodeLiteralField, String rootCommand, CommandType commandType) {
        this.commandsDirectory = commandsDirectory;
        this.literalCommandNodeLiteralField = literalCommandNodeLiteralField;
        this.rootCommand = rootCommand;
        this.commandType = commandType;
    }

    protected void registerCommands(CommandDispatcher<S> dispatcher, class_7157 registryAccess) {
        this.getCommands().entrySet().stream().filter(cmd -> ((CommandAlias)cmd.getValue()).getCommandMode() == CommandMode.COMMAND_REASSIGN).forEach(cmd -> {
            Object patt4830$temp;
            if (((CommandAlias)cmd.getValue()).getCommandMode() == CommandMode.COMMAND_REASSIGN && (patt4830$temp = cmd.getValue()) instanceof ReassignCommand) {
                ReassignCommand reassignCommand = (ReassignCommand)patt4830$temp;
                new ReassignCommandBuilder((String)cmd.getKey(), reassignCommand, this.literalCommandNodeLiteralField, this.getReassignedCommandMap(), this.getLoadedCommands(), this.commandType).buildCommand(dispatcher);
            }
        });
        this.getCommands().entrySet().stream().filter(cmd -> ((CommandAlias)cmd.getValue()).getCommandMode() != CommandMode.COMMAND_REASSIGN).forEach(cmd -> {
            Object patt5935$temp;
            Object patt5388$temp;
            if (((CommandAlias)cmd.getValue()).getCommandMode() == CommandMode.COMMAND_CUSTOM && (patt5388$temp = cmd.getValue()) instanceof CustomCommand) {
                CustomCommand customCommand = (CustomCommand)patt5388$temp;
                command = this.buildCustomCommand((String)cmd.getKey(), customCommand, this, registryAccess, dispatcher);
                if (command != null) {
                    dispatcher.register(command);
                    this.getLoadedCommands().add(customCommand.getCommand());
                }
            } else if ((((CommandAlias)cmd.getValue()).getCommandMode() == CommandMode.COMMAND_REDIRECT || ((CommandAlias)cmd.getValue()).getCommandMode() == CommandMode.COMMAND_REDIRECT_NOARG) && (patt5935$temp = cmd.getValue()) instanceof RedirectCommand) {
                RedirectCommand redirectCommand = (RedirectCommand)patt5935$temp;
                command = new CommandRedirectBuilder((String)cmd.getKey(), redirectCommand, this.commandType).buildCommand(dispatcher);
                if (command != null) {
                    command = (LiteralArgumentBuilder)command.requires(Permissions.require("commandaliases." + command.getLiteral(), true));
                    dispatcher.register(command);
                    this.getLoadedCommands().add(redirectCommand.getCommand());
                }
            }
        });
        CommandAliasesMod.logger().info("Registered/Reloaded all your commands :P, you can now single command nuke!");
    }

    protected void registerCommandAliasesCommands(CommandDispatcher<S> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal(this.rootCommand).requires(Permissions.require("commandaliases", 4))).executes(context -> {
            Optional modContainerOptional = FabricLoader.getInstance().getModContainer("commandaliases");
            modContainerOptional.ifPresent(modContainer -> this.sendFeedback((class_2172)context.getSource(), (class_2561)class_2561.method_43470((String)"Running Command Aliases").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)(" v" + modContainer.getMetadata().getVersion())).method_27692(class_124.field_1061)).method_27692(class_124.field_1070).method_10852((class_2561)class_2561.method_43470((String)", ")).method_10852((class_2561)class_2561.method_43470((String)"Click here to visit the wiki.").method_27695(new class_124[]{class_124.field_1073, class_124.field_1075}).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://wiki.commandaliases.flashyreese.me/"))))));
            return 1;
        })).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("scheduler").requires(Permissions.require("commandaliases.scheduler", 4))).then(((LiteralArgumentBuilder)this.literal("match").requires(Permissions.require("commandaliases.scheduler.match", 4))).then(this.argument("eventName", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String eventName = StringArgumentType.getString((CommandContext)context, (String)"eventName");
            if (this.getScheduler().contains(eventName)) {
                return 1;
            }
            return 0;
        })))).then(((LiteralArgumentBuilder)this.literal("remove").requires(Permissions.require("commandaliases.scheduler.remove", 4))).then(this.argument("eventName", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String eventName = StringArgumentType.getString((CommandContext)context, (String)"eventName");
            if (this.getScheduler().contains(eventName) && this.getScheduler().remove(eventName)) {
                return 1;
            }
            return 0;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("compare").requires(Permissions.require("commandaliases.compare", 4))).then(((LiteralArgumentBuilder)this.literal("equals").requires(Permissions.require("commandaliases.compare.equals", 4))).then(this.argument("string1", (ArgumentType)StringArgumentType.string()).then(this.argument("string2", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String string2;
            String string1 = StringArgumentType.getString((CommandContext)context, (String)"string1");
            if (string1.equals(string2 = StringArgumentType.getString((CommandContext)context, (String)"string2"))) {
                return 1;
            }
            return 0;
        }))))).then(((LiteralArgumentBuilder)this.literal("notEquals").requires(Permissions.require("commandaliases.compare.not_equals", 4))).then(this.argument("string1", (ArgumentType)StringArgumentType.string()).then(this.argument("string2", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String string2;
            String string1 = StringArgumentType.getString((CommandContext)context, (String)"string1");
            if (!string1.equals(string2 = StringArgumentType.getString((CommandContext)context, (String)"string2"))) {
                return 1;
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("compute").requires(Permissions.require("commandaliases.compute", 4))).then(((LiteralArgumentBuilder)this.literal("condition").requires(Permissions.require("commandaliases.compute.condition", 4))).then(this.argument("expression", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String expression = StringArgumentType.getString((CommandContext)context, (String)"expression");
            boolean value = (Boolean)new SimpleBooleanEvaluator().evaluate(expression);
            if (value) {
                return 1;
            }
            return 0;
        })))).then(((LiteralArgumentBuilder)this.literal("equals").requires(Permissions.require("commandaliases.compute.equals", 4))).then(this.argument("key", (ArgumentType)StringArgumentType.string()).then(this.argument("value1", (ArgumentType)StringArgumentType.string()).then(this.argument("value2", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String key = StringArgumentType.getString((CommandContext)context, (String)"key");
            boolean value = StringArgumentType.getString((CommandContext)context, (String)"value1").equals(StringArgumentType.getString((CommandContext)context, (String)"value2"));
            if (this.getDatabase().write(key, String.valueOf(value))) {
                return 1;
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)this.literal("notEquals").requires(Permissions.require("commandaliases.compute.not_equals", 4))).then(this.argument("key", (ArgumentType)StringArgumentType.string()).then(this.argument("value1", (ArgumentType)StringArgumentType.string()).then(this.argument("value2", (ArgumentType)StringArgumentType.string()).executes(context -> {
            boolean value;
            String key = StringArgumentType.getString((CommandContext)context, (String)"key");
            boolean bl = value = !StringArgumentType.getString((CommandContext)context, (String)"value1").equals(StringArgumentType.getString((CommandContext)context, (String)"value2"));
            if (this.getDatabase().write(key, String.valueOf(value))) {
                return 1;
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)this.literal("moreThan").requires(Permissions.require("commandaliases.compute.more_than", 4))).then(this.argument("key", (ArgumentType)StringArgumentType.string()).then(this.argument("value1", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("value2", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            boolean value;
            String key = StringArgumentType.getString((CommandContext)context, (String)"key");
            boolean bl = value = DoubleArgumentType.getDouble((CommandContext)context, (String)"value1") > DoubleArgumentType.getDouble((CommandContext)context, (String)"value2");
            if (this.getDatabase().write(key, String.valueOf(value))) {
                return 1;
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)this.literal("lessThan").requires(Permissions.require("commandaliases.compute.less_than", 4))).then(this.argument("key", (ArgumentType)StringArgumentType.string()).then(this.argument("value1", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("value2", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            boolean value;
            String key = StringArgumentType.getString((CommandContext)context, (String)"key");
            boolean bl = value = DoubleArgumentType.getDouble((CommandContext)context, (String)"value1") < DoubleArgumentType.getDouble((CommandContext)context, (String)"value2");
            if (this.getDatabase().write(key, String.valueOf(value))) {
                return 1;
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)this.literal("moreThanEquals").requires(Permissions.require("commandaliases.compute.more_than_equals", 4))).then(this.argument("key", (ArgumentType)StringArgumentType.string()).then(this.argument("value1", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("value2", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            boolean value;
            String key = StringArgumentType.getString((CommandContext)context, (String)"key");
            boolean bl = value = DoubleArgumentType.getDouble((CommandContext)context, (String)"value1") >= DoubleArgumentType.getDouble((CommandContext)context, (String)"value2");
            if (this.getDatabase().write(key, String.valueOf(value))) {
                return 1;
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)this.literal("lessThanEquals").requires(Permissions.require("commandaliases.compute.less_than_equals", 4))).then(this.argument("key", (ArgumentType)StringArgumentType.string()).then(this.argument("value1", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("value2", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            boolean value;
            String key = StringArgumentType.getString((CommandContext)context, (String)"key");
            boolean bl = value = DoubleArgumentType.getDouble((CommandContext)context, (String)"value1") <= DoubleArgumentType.getDouble((CommandContext)context, (String)"value2");
            if (this.getDatabase().write(key, String.valueOf(value))) {
                return 1;
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)this.literal("booleanEvaluate").requires(Permissions.require("commandaliases.compute.boolean_evaluate", 4))).then(this.argument("key", (ArgumentType)StringArgumentType.string()).then(this.argument("expression", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String key = StringArgumentType.getString((CommandContext)context, (String)"key");
            String expression = StringArgumentType.getString((CommandContext)context, (String)"expression");
            boolean value = (Boolean)new SimpleBooleanEvaluator().evaluate(expression);
            if (this.getDatabase().write(key, String.valueOf(value))) {
                return 1;
            }
            return 0;
        }))))).then(((LiteralArgumentBuilder)this.literal("numericalEvaluate").requires(Permissions.require("commandaliases.compute.numerical_evaluate", 4))).then(this.argument("key", (ArgumentType)StringArgumentType.string()).then(this.argument("expression", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String key = StringArgumentType.getString((CommandContext)context, (String)"key");
            String expression = StringArgumentType.getString((CommandContext)context, (String)"expression");
            double value = (Double)new ExtendedDoubleEvaluator().evaluate(expression);
            if (this.getDatabase().write(key, String.valueOf(value))) {
                return 1;
            }
            return 0;
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("database").requires(Permissions.require("commandaliases.database", 4))).then(((LiteralArgumentBuilder)this.literal("put").requires(Permissions.require("commandaliases.database.put", 4))).then(this.argument("key", (ArgumentType)StringArgumentType.string()).then(this.argument("value", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String key = StringArgumentType.getString((CommandContext)context, (String)"key");
            String value = StringArgumentType.getString((CommandContext)context, (String)"value");
            if (this.getDatabase().write(key, String.valueOf(value))) {
                return 1;
            }
            return 0;
        }))))).then(((LiteralArgumentBuilder)this.literal("delete").requires(Permissions.require("commandaliases.database.delete", 4))).then(this.argument("key", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String key = StringArgumentType.getString((CommandContext)context, (String)"key");
            if (this.getDatabase().read(key) != null && this.getDatabase().delete(key)) {
                return 1;
            }
            return 0;
        })))).then(((LiteralArgumentBuilder)this.literal("match").requires(Permissions.require("commandaliases.database.match", 4))).then(this.argument("key", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String key = StringArgumentType.getString((CommandContext)context, (String)"key");
            String value = this.getDatabase().read(key);
            if (value != null) {
                return 1;
            }
            return 0;
        })))).then(((LiteralArgumentBuilder)this.literal("get").requires(Permissions.require("commandaliases.database.get", 4))).then(this.argument("key", (ArgumentType)StringArgumentType.string()).executes(context -> {
            String key = StringArgumentType.getString((CommandContext)context, (String)"key");
            String value = this.getDatabase().read(key);
            if (value != null) {
                this.sendFeedback((class_2172)context.getSource(), (class_2561)class_2561.method_43470((String)value));
            }
            return 1;
        }))))).then(((LiteralArgumentBuilder)this.literal("reload").requires(Permissions.require("commandaliases.reload", 4))).executes(context -> this.commandAliasesReload(context, dispatcher, registryAccess)))).then(((LiteralArgumentBuilder)this.literal("load").requires(Permissions.require("commandaliases.load", 4))).executes(context -> this.commandAliasesLoad(context, dispatcher, registryAccess)))).then(((LiteralArgumentBuilder)this.literal("unload").requires(Permissions.require("commandaliases.unload", 4))).executes(context -> this.commandAliasesUnload(context, dispatcher, registryAccess))));
    }

    protected abstract void sendFeedback(S var1, class_2561 var2);

    protected abstract int commandAliasesLoad(CommandContext<S> var1, CommandDispatcher<S> var2, class_7157 var3);

    protected abstract int commandAliasesUnload(CommandContext<S> var1, CommandDispatcher<S> var2, class_7157 var3);

    protected abstract int commandAliasesReload(CommandContext<S> var1, CommandDispatcher<S> var2, class_7157 var3);

    protected abstract LiteralArgumentBuilder<S> buildCustomCommand(String var1, CustomCommand var2, AbstractCommandAliasesProvider<S> var3, class_7157 var4, CommandDispatcher<S> var5);

    protected void loadCommandAliases() {
        this.commands.clear();
        this.commands.putAll(this.loadCommandAliasesFromDirectory(this.commandsDirectory.toFile()));
    }

    protected void unregisterCommands(CommandDispatcher<S> dispatcher) {
        for (String string : this.loadedCommands) {
            dispatcher.getRoot().getChildren().removeIf(node -> node.getName().equals(cmd));
        }
        for (Map.Entry entry : this.reassignedCommandMap.entrySet()) {
            CommandNode commandNode = dispatcher.getRoot().getChildren().stream().filter(node -> node.getName().equals(entry.getValue())).findFirst().orElse(null);
            CommandNode commandReassignNode = dispatcher.getRoot().getChildren().stream().filter(node -> node.getName().equals(entry.getKey())).findFirst().orElse(null);
            if (commandNode == null || commandReassignNode != null) continue;
            dispatcher.getRoot().getChildren().removeIf(node -> node.getName().equals(entry.getValue()));
            try {
                this.literalCommandNodeLiteralField.set(commandNode, entry.getKey());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            dispatcher.getRoot().addChild(commandNode);
        }
        this.reassignedCommandMap.clear();
        this.loadedCommands.clear();
    }

    @NotNull
    private Map<String, CommandAlias> loadCommandAliasesFromDirectory(File file) {
        Object2ObjectOpenHashMap commandAliases = new Object2ObjectOpenHashMap();
        if (file.exists()) {
            String output = "\n" + this.loadAndRenderDirectoryTree(this.createDirectoryTree(file), (Map<String, CommandAlias>)commandAliases);
            CommandAliasesMod.logger().info(output);
        } else if (file.mkdir()) {
            CommandAliasesMod.logger().info("Command Aliases directory created at \"{}\"", (Object)file.getAbsolutePath());
        } else {
            CommandAliasesMod.logger().error("Could not create directory for Command Aliases at \"{}\"", (Object)file.getAbsolutePath());
        }
        return commandAliases;
    }

    private TreeNode<File> createDirectoryTree(File directory) {
        File[] files;
        if (!directory.isDirectory()) {
            throw new RuntimeException("Not a directory " + directory.getAbsolutePath());
        }
        TreeNode<File> rootTree = new TreeNode<File>(directory);
        for (File file : files = Objects.requireNonNull(directory.listFiles())) {
            if (file.isDirectory()) {
                rootTree.addChildTreeNode(this.createDirectoryTree(file));
                continue;
            }
            if (!file.isFile()) continue;
            rootTree.addChild(file);
        }
        return rootTree;
    }

    public String loadAndRenderDirectoryTree(TreeNode<File> tree, Map<String, CommandAlias> commandAliases) {
        List<StringBuilder> lines = this.loadAndRenderDirectoryTreeLines(tree, commandAliases);
        String newline = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        for (StringBuilder line : lines) {
            sb.append((CharSequence)line);
            if (lines.get(lines.size() - 1) == line) continue;
            sb.append(newline);
        }
        return sb.toString();
    }

    private Class<? extends CommandAlias> getCommandModeClass(CommandMode commandMode) {
        if (commandMode == CommandMode.COMMAND_CUSTOM) {
            return CustomCommand.class;
        }
        if (commandMode == CommandMode.COMMAND_REASSIGN) {
            return ReassignCommand.class;
        }
        if (commandMode == CommandMode.COMMAND_REDIRECT_NOARG || commandMode == CommandMode.COMMAND_REDIRECT) {
            return RedirectCommand.class;
        }
        return null;
    }

    private Map<String, CommandAlias> objectMapDataFormat(ObjectMapper objectMapper, File file, AtomicReference<String> state) throws IOException {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        Object2ObjectOpenHashMap commandAliases = new Object2ObjectOpenHashMap();
        CommandAlias commandAlias = (CommandAlias)objectMapper.readerFor(CommandAlias.class).readValue(file);
        if (commandAlias.getSchemaVersion() == 1) {
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
            commandAliases.put(file.getAbsolutePath(), (CommandAlias)objectMapper.readerFor(this.getCommandModeClass(commandAlias.getCommandMode())).readValue(file));
            state.set(" - Successfully loaded");
        } else {
            state.set(" - Unsupported schema version");
        }
        return commandAliases;
    }

    public List<StringBuilder> loadAndRenderDirectoryTreeLines(TreeNode<File> tree, Map<String, CommandAlias> commandAliases) {
        ArrayList<StringBuilder> result = new ArrayList<StringBuilder>();
        AtomicReference<String> state = new AtomicReference<String>("");
        if (tree.getData().isFile()) {
            File file = tree.getData();
            try {
                if (file.getAbsolutePath().endsWith(".toml")) {
                    commandAliases.putAll(this.objectMapDataFormat(this.tomlMapper, file, state));
                } else if (file.getAbsolutePath().endsWith(".json")) {
                    commandAliases.putAll(this.objectMapDataFormat(this.jsonMapper, file, state));
                } else if (file.getAbsolutePath().endsWith(".json5")) {
                    commandAliases.putAll(this.objectMapDataFormat(this.json5Mapper, file, state));
                } else if (file.getAbsolutePath().endsWith(".yml") || file.getAbsolutePath().endsWith(".yaml")) {
                    commandAliases.putAll(this.objectMapDataFormat(this.yamlMapper, file, state));
                } else {
                    state.set(" - Unsupported data format type");
                }
            }
            catch (IOException e) {
                state.set(" - Failed to load");
                CommandAliasesMod.logger().error("Failed to load file at \"{}\" throws {}", (Object)file.getAbsolutePath(), (Object)e);
            }
        }
        result.add(new StringBuilder().append(tree.getData().getName()).append(state.get()));
        Iterator<TreeNode<File>> iterator = tree.getChildren().iterator();
        while (iterator.hasNext()) {
            List<StringBuilder> subtree = this.loadAndRenderDirectoryTreeLines(iterator.next(), commandAliases);
            Iterator<StringBuilder> iteratorSB = subtree.iterator();
            if (iterator.hasNext()) {
                result.add(iteratorSB.next().insert(0, "\u251c\u2500\u2500 "));
                while (iteratorSB.hasNext()) {
                    result.add(iteratorSB.next().insert(0, "\u2502   "));
                }
                continue;
            }
            result.add(iteratorSB.next().insert(0, "\u2514\u2500\u2500 "));
            while (iteratorSB.hasNext()) {
                result.add(iteratorSB.next().insert(0, "    "));
            }
        }
        return result;
    }

    LiteralArgumentBuilder<S> literal(String literal) {
        return LiteralArgumentBuilder.literal((String)literal);
    }

    <T> RequiredArgumentBuilder<S, T> argument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    public Map<String, CommandAlias> getCommands() {
        return this.commands;
    }

    public List<String> getLoadedCommands() {
        return this.loadedCommands;
    }

    public Map<String, String> getReassignedCommandMap() {
        return this.reassignedCommandMap;
    }

    public Path getCommandsDirectory() {
        return this.commandsDirectory;
    }

    public AbstractDatabase<String, String> getDatabase() {
        return this.database;
    }

    public void setDatabase(AbstractDatabase<String, String> database) {
        this.database = database;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }
}

