/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.commandaliases.config;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class CommandAliasesConfig {
    private static final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();
    public final DatabaseSettings databaseSettings = new DatabaseSettings();
    public final DebugSettings debugSettings = new DebugSettings();
    private File file;

    public static CommandAliasesConfig load(File file) {
        CommandAliasesConfig config;
        block8: {
            if (file.exists()) {
                try (FileReader reader = new FileReader(file);){
                    config = (CommandAliasesConfig)gson.fromJson((Reader)reader, CommandAliasesConfig.class);
                    break block8;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not parse config", e);
                }
            }
            config = new CommandAliasesConfig();
        }
        config.file = file;
        config.writeChanges();
        return config;
    }

    public void writeChanges() {
        File dir = this.file.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new RuntimeException("Could not create parent directories");
            }
        } else if (!dir.isDirectory()) {
            throw new RuntimeException("The parent file is not a directory");
        }
        try (FileWriter writer = new FileWriter(this.file);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save configuration file", e);
        }
    }

    public static class DatabaseSettings {
        public DatabaseMode databaseMode = DatabaseMode.LEVELDB;
        public String host = "localhost";
        public int port = 3306;
        public String database = "command_aliases";
        public String user = "root";
        public String password = "";
    }

    public static class DebugSettings {
        public boolean debugMode = false;
        public boolean showProcessingTime = false;
        public boolean broadcastToOps = false;
    }

    public static enum DatabaseMode {
        IN_MEMORY,
        LEVELDB,
        MYSQL,
        REDIS;

    }
}

