/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.commandaliases.math;

import com.fathzer.soft.javaluator.AbstractEvaluator;
import com.fathzer.soft.javaluator.Operator;
import com.fathzer.soft.javaluator.Parameters;
import java.util.Iterator;

public class SimpleBooleanEvaluator
extends AbstractEvaluator<Boolean> {
    public static final Operator NEGATE = new Operator("!", 1, Operator.Associativity.RIGHT, 3);
    public static final Operator OR = new Operator("||", 2, Operator.Associativity.LEFT, 1);
    private static final Operator AND = new Operator("&&", 2, Operator.Associativity.LEFT, 2);
    private static final Parameters PARAMETERS = new Parameters();

    public SimpleBooleanEvaluator() {
        super(PARAMETERS);
    }

    protected Boolean toValue(String literal, Object evaluationContext) {
        return Boolean.valueOf(literal);
    }

    protected Boolean evaluate(Operator operator, Iterator<Boolean> operands, Object evaluationContext) {
        if (operator == NEGATE) {
            return operands.next() == false;
        }
        if (operator == OR) {
            Boolean o1 = operands.next();
            Boolean o2 = operands.next();
            return o1 != false || o2 != false;
        }
        if (operator == AND) {
            Boolean o1 = operands.next();
            Boolean o2 = operands.next();
            return o1 != false && o2 != false;
        }
        return (Boolean)super.evaluate(operator, operands, evaluationContext);
    }

    static {
        PARAMETERS.add(AND);
        PARAMETERS.add(OR);
        PARAMETERS.add(NEGATE);
    }
}

