/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.commandaliases.storage.database.redis;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import me.flashyreese.mods.commandaliases.storage.database.AbstractDatabase;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisImpl
implements AbstractDatabase<String, String> {
    private final String host;
    private final int port;
    private final int database;
    private final String user;
    private final String password;
    private JedisPool jedisPool;

    public RedisImpl(String host, int port, int database, String user, String password) {
        this.host = host;
        this.port = port;
        this.database = database;
        this.user = user;
        this.password = password;
    }

    @Override
    public boolean open() {
        if (this.jedisPool == null) {
            this.jedisPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.host, this.port, 0, this.user, this.password, this.database);
            return true;
        }
        return false;
    }

    @Override
    public boolean close() {
        if (this.jedisPool != null) {
            this.jedisPool.close();
            return true;
        }
        return false;
    }

    @Override
    public boolean write(String key, String value) {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.set(key, value).equals("OK");
            return bl;
        }
    }

    @Override
    public String read(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            String string = jedis.get(key);
            return string;
        }
    }

    @Override
    public boolean delete(String key) {
        try (Jedis jedis = this.jedisPool.getResource();){
            boolean bl = jedis.del(key) == 1L;
            return bl;
        }
    }

    @Override
    public Map<String, String> map() {
        Object2ObjectOpenHashMap map = new Object2ObjectOpenHashMap();
        try (Jedis jedis = this.jedisPool.getResource();){
            jedis.keys("*").forEach(arg_0 -> RedisImpl.lambda$map$0((Map)map, jedis, arg_0));
        }
        return map;
    }

    private static /* synthetic */ void lambda$map$0(Map map, Jedis jedis, String key) {
        map.put(key, jedis.get(key));
    }
}

